// $Id: Widget.cc,v 1.31 2003/04/07 06:21:25 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "Widget.hh"
#include "writers/WriterBase.hh"
#include <cstring>

static std::string UniqueName(const std::string &prefix,const void *addr)
{  std::string ret(prefix);
   unsigned long val=(unsigned long)addr;
   if (sizeof(val)<sizeof(addr)) 
      std::cerr<<"Warning: Widget::UniqueName: truncating address\n";
   unsigned int bit;
   const int size=5;
   for (bit=0;bit<8*(sizeof val);bit+=size)
      ret+="QCDGHKLMJNPVWYZXqcdghklmjnpvwyzx"[(val>>bit)&((1<<size)-1)];
      // selecting really unreadable names
   return ret;
}

const std::string Widget::Name() const throw()
{  if (!name.empty()) return name;
   if (!Configuration.glade2) name=tag->getString("name");
   else name=tag->getAttr("id");
   if (name.empty()) name=UniqueName("Widget",tag);
   return name;
}

const ChildParamList Widget::get_Child_params() const throw()
{  const Tag *t=0;
   if (Configuration.glade2) t=childtag->find("packing");
   else t=tag->find("child");
   if (t) return ChildParamList(*t);

   static const Tag empty_list("child");
   return ChildParamList(empty_list);
}

Subwidget Widget::subwidgettype(const Widget &w) const throw()
{  return LookupWriter(*this).IsSubwidget(*this,w);
}

const std::string Widget::getProperty(const std::string &name, const std::string &_default) const
{  if (Configuration.glade2)
   {  FOR_EACH_CONST_TAG_OF(i,*tag,"property")
         if (i->getAttr("name")==name) 
            return i->Value();
      return _default;
   }
   else return tag->getString(name,_default);
}

bool Widget::hasProperty(const std::string &name) const
{  if (Configuration.glade2)
   {  FOR_EACH_CONST_TAG_OF(i,*tag,"property")
         if (i->getAttr("name")==name) 
            return true;
      return false;
   }
   else return tag->hasTag(name);
}

void Widget::setProperty(const std::string &name, const std::string &value)
{  if (Configuration.glade2)
   {  FOR_EACH_TAG_OF(i,*tag,"property")
      {  if (i->getAttr("name")==name) 
         {  i->Value(value);
            return;
         }
      }
      Tag nw("property",value);
      nw.setAttr("name",name);
      tag->push_back(nw);
   }
   else tag->mark(name,value);
}

const std::string Widget::Class() const throw()
{  if (Configuration.glade2)
   {  if (tag->Type()=="placeholder") return "Placeholder";
      return tag->getAttr("class");
   }
   else return tag->getString("class"); 
}

const std::string Widget::ChildName() const throw()
{  return Configuration.glade2 ? (!childtag ? "" : childtag->getAttr("internal-child"))
			: tag->getString("child_name"); }
bool Widget::hasChildren() const throw()
{  return tag->hasTag(Widget::const_contained_iterator::type); }

Widget::const_iterator Widget::begin() const
{  return const_iterator(find(tag->begin(),tag->end(),Widget::const_contained_iterator::type),tag->end(),Widget::const_contained_iterator::type);
}

Widget::iterator Widget::begin()
{  assert(!is_const); // too hard?
   return iterator(find(tag->begin(),tag->end(),Widget::const_contained_iterator::type),tag->end(),Widget::const_contained_iterator::type);
}

Widget::const_iterator Widget::get_Accels() const throw()
{  return const_iterator(find(tag->begin(),tag->end(),"accelerator"),tag->end(),"accelerator");
}

Widget::const_contained_iterator Widget::begin_contained(InternalSelection _internal,bool debug) const
{  const_contained_iterator it(find(tag->begin(),tag->end(),Configuration.glade2?"child":"widget"),tag,_internal,debug);
   return it;
}

Widget Widget::getParent() const throw(std::out_of_range)
{  Tag *parent_ptr=tag->parent();
   if (!parent_ptr) throw std::out_of_range("no parent");
   if (Configuration.glade2) 
   {  parent_ptr=parent_ptr->parent();
      if (!parent_ptr || parent_ptr->Type()!="widget") throw std::out_of_range("no parent");
      return Widget(parent_ptr,parent_ptr->parent());
   }
   return Widget(parent_ptr,parent_ptr);
}
