// $Id: WidgetFile.hh,v 1.8 2001/10/11 14:07:23 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#ifndef WIDGETFILE_HH
#define WIDGETFILE_HH

#include <CxxFile.hh>
#include <Widget.hh>
#include <File_type.hh>

class WidgetFile : public CxxFile
{	const Tag *top;
	File_type _type;
	bool has_requirements;
public:
	WidgetFile(const Widget &w, File_type tp);
	WidgetFile() : top(0), _type(File_UNKNOWN), has_requirements(false) {}
	void open(const Widget &w, File_type tp);
	void open(const Widget *w, File_type tp)
	{  open(*w,tp); }
	const std::string FileName(int flags=File_NODIR)
	{  return FileName(_type,flags); }
	const std::string FileName(File_type tp,int flags=File_NODIR);
	const File_type type() const { return _type; }
	const std::string widgetName() const
	{  return Widget(*top).Name(); }
	bool hasRequirements() const
	{  return has_requirements; }
	void hasRequirements(bool set) 
	{  has_requirements=set; }
   void close();
};

#endif
