// $Id: fontselection.cc,v 1.1 2002/06/17 07:04:58 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 2002  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "dialog.hh"

class Gtk_FontSelectionDialog : public Gtk_Dialog
{public:
	typedef Gtk_Dialog Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gtk_FontSelectionDialog();
	virtual Subwidget IsSubwidget(const Widget &parent,const Widget &w2) const;
	virtual void ConstructionArgs(const Widget &w, CxxFile &f) const 
	{ f.FunctionArg() << Configuration.Translatable(w.getProperty("title")); }
	virtual bool NeedExplicitCtor(const Widget &w) const
	{ return w.hasProperty("title"); }
	virtual const std::string InternalInstance(const Widget &parent,const Widget &w2) const;
};

static Gtk_FontSelectionDialog Gtk_FontSelectionDialog;

const std::string Gtk_FontSelectionDialog::TypeName(const Widget &w) const
{  return GtkPrefix()+"FontSelectionDialog";
}

const std::string Gtk_FontSelectionDialog::IncludeName(const Widget &w) const
{  return Configuration.GtkmmIncludePath()+"fontselection.h";
}

Gtk_FontSelectionDialog::Gtk_FontSelectionDialog()
{  Writer["GtkFontSelectionDialog"]=this;
}

Subwidget Gtk_FontSelectionDialog::IsSubwidget(const Widget &w,const Widget &ch) const
{  const std::string chn(ch.ChildName());
   if (chn=="cancel_button" || chn=="apply_button"
   	|| chn=="ok_button" || chn=="font_selection") return is_Subwidget;
   return Parent::IsSubwidget(w,ch);;
}

const std::string Gtk_FontSelectionDialog::InternalInstance(const Widget &parent,const Widget &w2) const
{  const std::string chn(w2.ChildName());
   if (chn=="cancel_button") return "get_cancel_button()->";
   if (chn=="ok_button") return "get_ok_button()->";
   if (chn=="apply_button") return "get_apply_button()->";
   if (chn=="font_selection") return "get_font_selection()->";
   return Parent::InternalInstance(parent,w2);
}

//------------------------------------------------------------------------

#include "box.hh"

class Gtk_FontSelection : public Gtk_VBox
{public:
	typedef Gtk_VBox Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gtk_FontSelection(bool base_class_init=true);
	// we have to override Gtk_Box's constructor
	virtual bool NeedExplicitCtor(const Widget &w) const
	{  return false; }
	virtual void ConstructionArgs(Widget const &w, CxxFile &f) const
	{  f.FunctionArg(); }
	void Configure(const Widget &w, CxxFile &f,const std::string &instance) const;
};

static Gtk_FontSelection Gtk_FontSelection(false);

const std::string Gtk_FontSelection::TypeName(const Widget &w) const
{  return GtkPrefix()+"FontSelection";
}

const std::string Gtk_FontSelection::IncludeName(const Widget &w) const
{  return Configuration.GtkmmIncludePath()+"fontselection.h";
}

Gtk_FontSelection::Gtk_FontSelection(bool base_class_init)
{  if (!base_class_init) Writer["GtkFontSelection"]=this;
}

void Gtk_FontSelection::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);
   WriteTranslatableProperty(w,f,instance, "preview_text");
}

