// $Id: gnome_dockitem.cc,v 1.6 2002/11/04 11:31:03 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "bin.hh"

class Gnome_DockItem : public Gtk_Bin
{public:
	typedef Gtk_Bin Parent;
	virtual const std::string TypeName(const Widget &w) const;
	virtual const std::string IncludeName(const Widget &w) const;
	Gnome_DockItem();
	virtual bool NeedExplicitCtor(const Widget &w) const;
	virtual void ConstructionArgs(const Widget &w, CxxFile &f) const;
	virtual void Configure(const Widget &w, CxxFile &f,const std::string &instance) const;
};

static Gnome_DockItem Gnome_DockItem;

const std::string Gnome_DockItem::TypeName(const Widget &w) const
{  return GnomeUIPrefix()+"DockItem";
}

const std::string Gnome_DockItem::IncludeName(const Widget &w) const
{  return Configuration.GnomeUImmIncludePath()+"dock-item.h";
}

Gnome_DockItem::Gnome_DockItem()
{  Writer["GnomeDockItem"]=this;
}

void Gnome_DockItem::ConstructionArgs(const Widget &w, CxxFile &f) const
{  f.FunctionArg();
   const std::string name(w.getProperty("name","DockItem"));
   std::string options("0");
   if (w.getBoolProperty("exclusive")) options+="|GNOME_DOCK_ITEM_BEH_EXCLUSIVE";
   if (w.getBoolProperty("never_floating")) options+="|GNOME_DOCK_ITEM_BEH_NEVER_FLOATING";
   if (w.getBoolProperty("never_vertical")) options+="|GNOME_DOCK_ITEM_BEH_NEVER_VERTICAL";
   if (w.getBoolProperty("never_horizontal")) options+="|GNOME_DOCK_ITEM_BEH_NEVER_HORIZONTAL";
   if (w.getBoolProperty("locked")) options+="|GNOME_DOCK_ITEM_BEH_LOCKED";
   if (options.size()>1) // strip leading '0|'
      options=std::string(options.begin()+2,options.end());
   // cast it (strange that this is necessary ...
   options="GnomeDockItemBehavior("+options+")";
   
   f << Configuration.CString_WithQuotes(name);
   f.FunctionArg(options);
}

bool Gnome_DockItem::NeedExplicitCtor(const Widget &w) const
{  return true; }

void Gnome_DockItem::Configure(const Widget &w, CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);
   WriteEnumPropertyNS(w,f,instance, "shadow_type");
   // orientation
#warning orientation support missing
}
