// $Id: pixmapmenuitem.cc,v 1.10 2002/07/12 14:44:25 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
// strange wrapper - uses Gnome Widget, wrapped via Gtk_MenuItem

#include "menuitem.hh"

class Gtk_PixmapMenuItem : public Gtk_MenuItem
{public:
	typedef Gtk_MenuItem Parent;
	// inherit TypeName
	// inherit IncludeName
	Gtk_PixmapMenuItem();
	const std::string GtkName(const Widget &w) const
	{  return "GtkPixmapMenuItem"; }
	const std::string GtkCast(const Widget &w) const
	{  return "GTK_MENU_ITEM"; }
	virtual void GHInclude(const Widget &w, CxxFile &f) const;
	virtual void ApplyPreferences(Tag &t) const
	{  assert(Configuration.gnome_support);
	   Parent::ApplyPreferences(t);
	}
	virtual void Configure(const Widget &w, CxxFile &f, const std::string &instance) const
	{  Parent::Configure(w,f,instance);
	   // fix a gtkmm2 bug
	   if (GTKMM2 && Configuration.gtkmm_version<Pkg_Version(1,3,18))
	      f.Statement() << instance << "get_image()->show()";
	}
};

static Gtk_PixmapMenuItem Gtk_PixmapMenuItem;

void Gtk_PixmapMenuItem::GHInclude(const Widget &w, CxxFile &f) const
{  f.Include("libgnomeui/gtkpixmapmenuitem.h"); 
//   f.Include("gtk/gtkpixmap.h");
   Parent::GHInclude(w,f);
}

Gtk_PixmapMenuItem::Gtk_PixmapMenuItem()
{  Writer["GtkPixmapMenuItem"]=this;
}

