// $Id: box.cc,v 1.30 2003/03/31 14:09:27 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000  Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "box.hh"

static Gtk_Box Gtk_Box(false);

const std::string Gtk_Box::TypeName(const Widget &w) const
{  return GtkPrefix()+(w.Class()[3]=='H' ?"HBox":"VBox");
}

const std::string Gtk_Box::IncludeName(const Widget &w) const
{  return Configuration.GtkmmIncludePath()+"box.h";
}

Gtk_Box::Gtk_Box(bool base_class_init)
{  if (!base_class_init)
   {  Writer["GtkHBox"]=this;
      Writer["GtkVBox"]=this;
   }
}

void Gtk_Box::ConstructionArgs(const Widget &w, CxxFile &f) const
{  f.FunctionArg() << PRINT_BOOL(w.getBoolProperty("homogeneous",homo_def));
   f.FunctionArg() << w.getIntProperty("spacing",spac_def);
}

bool Gtk_Box::NeedExplicitCtor(const Widget &w) const
{  return w.getBoolProperty("homogeneous",homo_def)!=homo_def
	|| w.getIntProperty("spacing",spac_def)!=spac_def; }


void Gtk_Box::AddChild(const Widget &w,CxxFile &f,const std::string &instance) const
{  const ChildParamList ch(w.get_Child_params());
   bool pack_end(ch.getProperty("pack","GTK_PACK_START")=="GTK_PACK_END");
   bool expand(ch.getBoolProperty("expand",true));
   bool fill(ch.getBoolProperty("fill",true));
   int padding(ch.getIntProperty("padding",0));

   // this is for dialog (see there)
   if (GTKMM2 && w.hasProperty("response_id")) return;
   
   f.Statement() << instance 
        << (pack_end?"pack_end":"pack_start")
        << '(' << Reference(w);
   if (expand && fill && !padding) ;
   else if (GTKMM1)
      f << ", " << PRINT_BOOL(expand) << ", " << PRINT_BOOL(fill)
      	 << ", " << padding;
   else // GTKMM2
   {  std::string AttachOptions;
      if (!expand) AttachOptions="Gtk::PACK_SHRINK";
      else if (fill) AttachOptions="Gtk::PACK_EXPAND_WIDGET";
      else AttachOptions="Gtk::PACK_EXPAND_PADDING";
      f << ", " << AttachOptions << ", " << padding;
   }
   f << ')';
}

void Gtk_Box::Configure(const Widget &w,CxxFile &f,const std::string &instance) const
{  Parent::Configure(w,f,instance);
   if (!w.ChildName().empty()) // our ctor was never called
   {  WriteBoolProperty(w,f,instance, "homogeneous");
      WriteIntProperty(w,f,instance, "spacing");
   }
}
