// $Id: radiobutton.cc,v 1.37 2004/05/12 10:17:07 christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *  Copyright (C) 1999-2000 Adolf Petig GmbH & Co. KG, written by Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "radiobutton.hh"
#include <Cxx_Fileset.hh>

static Gtk_RadioButton Gtk_RadioButton;

const std::string Gtk_RadioButton::TypeName(const Widget &w) const
{  return GtkPrefix()+"Radio"+(IsToolItem(w)?"Tool":"")+"Button";
}

const std::string Gtk_RadioButton::IncludeName(const Widget &w) const
{  return Configuration.GtkmmIncludePath()+"radio"+(IsToolItem(w)?"tool":"")+"button.h";
}

Gtk_RadioButton::Gtk_RadioButton()
{  Writer["GtkRadioButton"]=this;
   Writer["GtkRadioToolButton"]=this;
   Writer["radiobutton"]=this; // is this ever needed? 2.0 ???
   Writer["radio"]=this;  // 1.1.3
}

void Gtk_RadioButton::ConstructionArgs(const Widget &w, CxxFile &f) const
{  f.FunctionArg();
   f << "_RadioBGroup_" << Configuration.InstanceName(w.getProperty("group",w.Name()));
   // checkbutton's arguments
   Parent::ConstructionArgs(w,f);
}

void Gtk_RadioButton::CreatePointer(const Widget &w,CxxFile &f) const
{  ToolBar_vars(w,f); // create local Group var
   Parent::CreatePointer(w,f);
}

void Gtk_RadioButton::ToolBarElemArgs(const Widget &w, CxxFile &f) const
{  if (!GTKMM24 || !(w.hasProperty("icon") || w.hasProperty("stock_pixmap")))
      f.FunctionArg() << "_RadioBGroup_" << w.getProperty("group",w.Name());
   Parent::ToolBarElemArgs(w,f);
}

void Gtk_RadioButton::ToolBar_vars(const Widget &w,CxxFile &f) const
{  std::string group=w.getProperty("group",w.Name());
   if (Cxx_Fileset::NeedToDeclareRadioGroup("B:"+group))
      f.Declaration() << "Gtk::RadioButton::Group _RadioBGroup_" 
		<< Configuration.InstanceName(group);
}

void Gtk_RadioButton::GCInclude(const Widget &w, CxxFile &f) const
{  f.Include(Configuration.GtkmmIncludePath()+"radiobutton.h");
   Parent::GCInclude(w,f);
}

std::string Gtk_RadioButton::ToolBarElemName(const Widget &w) const
{  if (GTKMM24)
      return GtkPrefix()+"RadioToolButton";
   else
      return ToolBarElemPrefix()+"RadioElem"; 
}
