#include <cstdio>
#include <string>
#include <Configuration.hh>

// parts taken from
/* xpmtoppm.c - read an X11 pixmap file and produce a portable pixmap
**
** Copyright (C) 1991 by Jef Poskanzer.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
**
*/

#define MAX_LINE 2048
  /* The maximum size XPM input line we can handle. */
  
static std::string
readXpm3Header(FILE * const stream)
{   char line[MAX_LINE],w[MAX_LINE];
    
    /* Read the assignment line */
    fgets(line, sizeof(line), stream);
    
    *w=0;
    sscanf(line,"static char%*[ *]%[_A-Za-z0-9]",w);
    return w;
}

static std::string ReadXPMFile(FILE * const stream)
{  char line[MAX_LINE], str1[MAX_LINE];
   int rc;

    /* Read the header line */
    fgets(line, sizeof(line), stream);
    
    rc = sscanf(line, "/* %s */", str1);
    if (rc == 1 && strncmp(str1, "XPM", 3) == 0) {
        /* It's an XPM version 3 file */
        return readXpm3Header(stream);
    }
    // we don't care about Version 1 files, the parsing is too
    // complicated and we should reasonably never encounter one
    return "";
}

std::string xpmname(const std::string &file)
{  if (file.empty()) return "";
   std::string file_with_path;
   if (file[0]!='/' && file.substr(0,2)!="./" 
   	&& !Configuration.pixmap_dir.empty())
      file_with_path=Configuration.pixmap_dir+"/"+file;
   else file_with_path=file;
   
   FILE *f;
   if (!(f=fopen(file_with_path.c_str(),"r"))) return "";
   std::string res=ReadXPMFile(f);
   fclose(f);
   return res;
}
