/*
 * BackupInfo.java
 *
 * Created on January 12, 2004, 2:01 PM
 */

package com.sun.enterprise.config.backup;

import com.sun.enterprise.config.backup.EnvironmentConstants;

/**
 *
 * @author  bnevins
 */
public final class BackupRequest  //implements com.sun.enterprise.config.backup.BackupRequest
{
	public BackupRequest()
	{
	}
	
	///////////////////////////////////////////////////////////////////////////
	///////////       Setters and Getters                  ////////////////////
	///////////////////////////////////////////////////////////////////////////
	public String[] getDirsToBackup()
	{
		return dirsToBackup;
	}	
	
	public void setDirsToBackup(String[] dirs)
	{
		dirsToBackup = dirs;
	}
	
	public String getDirToStoreBackupFiles()
	{
		return dirToStoreBackupFiles;
	}	
	
	public void setDirToStoreBackupFiles(String dir)
	{
		dirToStoreBackupFiles = dir;
	}

	public void setBackupStorageType(String type)
	{
		backupStorageType = type;
	}
	
	public String getBackupStorageType()
	{
		return backupStorageType ;
	}
	
	public BackupCommand getCommand()
	{
		return command;
	}

	public void setCommand(String cmd)
	{
		command = BackupCommand.parse(cmd);
	}
	
	public void setUserInfo(String info)
	{
		userInfo = info;
	}

	public String getUserInfo()
	{
		return userInfo;
	}
	///////////////////////////////////////////////////////////////////////////
	///////////       Public Methods                       ////////////////////
	///////////////////////////////////////////////////////////////////////////
	
	public void verify()
	{
		String s = "Verify error";

		if(command == null)
			throw new BackupAbortException(s, "No command was specified");
		
		if(dirToStoreBackupFiles == null || dirToStoreBackupFiles.length() <= 0)
			throw new BackupAbortException(s, "No dir to backup to was specified");
	
		if(command == BackupCommand.backup || command == BackupCommand.restore)
		{
			if(dirsToBackup == null || dirsToBackup.length <= 0)
				throw new BackupAbortException(s, "No dirs to backup specified");

			if(backupStorageType == null || backupStorageType.length() <= 0)
				throw new BackupAbortException(s, "No backup storage type was specified");
		}
		else
		{
			dirsToBackup		= new String[] { "unused" };
			backupStorageType	= "unused";
		}

			
		/** WBN FIXME TODO 
		 * Do lot's of time-consuming checks like -- is it a dir?  are the files writable?
		 * Create the output dir if it doesn't exist -- or treat it as an error?
		 *
		File f = new File(dirToStoreBackupFiles);
		
		if(f.exists() && 
		 **/
		
	}
	
	private String[]		dirsToBackup;
	private String			dirToStoreBackupFiles;
	private String			backupStorageType;
	private BackupCommand	command;
	private String			userInfo = null;	// null is acceptable...
}
