/*
 * MaxBackupMonitor.java
 *
 * Created on December 21, 2003, 8:29 PM
 */

package com.sun.enterprise.config.backup;

import java.io.IOException;
import java.io.File;
import java.util.Arrays;
import java.util.ArrayList;
import java.util.List;
import java.io.FilenameFilter;
import com.sun.enterprise.config.backup.utils.LoggerHelper;
import com.sun.enterprise.config.backup.pluggable.EnvironmentFactory;
import com.sun.enterprise.config.backup.pluggable.BackupEnvironment;
import com.sun.enterprise.config.backup.utils.FactoryHelper;
import com.sun.enterprise.config.backup.status.BackupStatus;
import com.sun.enterprise.config.backup.status.ListBackupStatus;


/**
 * Anything extraneous in the monitored directory will
 * not be touched
 * @author  sridatta
 */
public class BackupStorageMonitor extends StorageMonitor {
    
    /** Creates a new instance of MaxBackupMonitor */
    public BackupStorageMonitor() {
    }
    
    protected int getMaxBackups() {
        return getEnv().getMaxBackups();
    }

    
    protected String getFileNamePrefix() {
     return   getEnv().getBackupFileNamePrefix();
    }
    
    protected  FilenameFilter getFileNameFilter() {
     return new BackupFileNameFilter(   
                    getEnv().getBackupFileNamePrefix());
    }
    
    protected String getMonitoredDirectory() {
     return getEnv().getDirectoryToStoreBackupFiles();
    } 
    
    public BackupStatus[] listBackupStatus() {
        File[] f = null;
        BackupStatus[] bss = null;
        try {
            f = getFiles();
            
            if(f == null || f.length == 0) return null;
            
            bss = new BackupStatus[f.length];
            for (int i = 0 ; i < f.length; i++) {
                BackupStatus bs = new ListBackupStatus(f[i]);
                bss[i] = bs;
            }
        } catch(Exception e) {
            //ignore
            LoggerHelper.error("error_listing_backups", e);
        }
        
        return bss;
    }
}