/*
 * BackupManager.java
 *
 * Created on January 16, 2004, 11:11 AM
 */

package com.sun.enterprise.config.backup.appserver;

import com.sun.enterprise.config.backup.*;
import com.sun.enterprise.config.backup.utils.*;
import com.sun.enterprise.config.backup.status.*;

/**
 *
 * @author  bnevins
 */
public class BackupManager
{
	public BackupManager()
	{
	}
	
	public void execute(BackupRequest request)
	{
		request.verify();
		String[] dirs = request.getDirsToBackup();
		String allDirs = dirs[0];
		
		for(int i = 1; i < dirs.length; i++)
			allDirs += ',' + dirs[i];
		
		SystemPropsHelper.setProperty(EnvironmentConstants.DIRS_TO_BACKUP,				allDirs);
		SystemPropsHelper.setProperty(EnvironmentConstants.DIR_TO_STORE_BACKUP_FILES,	request.getDirToStoreBackupFiles());
		SystemPropsHelper.setProperty(EnvironmentConstants.BACKUP_STORAGE_TYPE,			request.getBackupStorageType());
		BackupCommand cmd = request.getCommand();
		
		BackupRestore bri	= Util.getBackupRestore();
		Status[] statuses	= new Status[1];
		BackupHistory bh	= null; 
		try
		{
			if(cmd == BackupCommand.backup)
			{
				statuses[0] = bri.backup(request.getUserInfo());
			}
			else if(cmd == BackupCommand.restore)
			{
				statuses[0] = bri.restore();
			}
			else if(cmd == BackupCommand.undorestore)
			{
				statuses[0] = bri.undoRestore();
			}
			else if(cmd == BackupCommand.listbackups)
			{
				statuses = bri.listBackups();
			}
			else if(cmd == BackupCommand.listhistory)
			{
				// temp bnevins wbn fixme
				statuses = null;
				bh = bri.getBackupHistory(6);
			}
		}
		catch(BackupAbortException bae)
		{
			throw bae;
		}
		catch(BackupException be)
		{
			// bnevins wbn fixme temp tbd todo
			throw new BackupAbortException("qqqqq", "wwwww", be);
		}
		catch(Exception e)
		{
			throw new BackupAbortException("xxx", "yyy", e);
		}
		
		if(bh != null)
		{
			System.out.println(bh.toString());
		}
		if(statuses != null)
		{
			for(int i = 0; i < statuses.length; i++)
			{
				System.out.println(statuses[i]);
			}
		}
	}
}



/******
 *
 *         if("backup".equals(args[0])) {
                String userInfo = null;
                if(args.length == 1) { // && (args[1] == null || "".equals(args[1]))) {
                    s = bri.backup(null);
                } else if(args.length == 2) { //&& (args[2] == null || "".equals(args[2]))) {
                    System.out.println("info=" + args[1]);
                    s =    bri.backup(args[1]);
                } else if(args.length == 3) {
                    s = bri.backup(args[1], args[2]);
                } else {
                    usage();
                    return;
                }
            } else if ("restore".equals(args[0])) {
                s = bri.restore();
            } else if("undorestore".equals(args[0])) {
                s = bri.undoRestore();
            } else if("listbackups".equals(args[0])) {
                BackupStatus[] bs = bri.listBackups();
                System.out.println("==================");
                
                printBackupStatus(bs);
                System.out.println("==================");
                
                return;
            } else if("listhistory".equals(args[0])) {
                int n=HISTORY_NUMBER;
                if(args.length==2) { // && args != null && !args[1].equals("") ) {
                    n = getHistoryNumber(args[1]);
                }
                BackupHistory bh = bri.getBackupHistory(n);
                System.out.println("==================");
                
                //printBackupStatus(bh);
                System.out.println(bh);
                System.out.println("==================");
   */

