/*
 * BackupPhases.java
 *
 * Created on December 24, 2003, 10:07 AM
 */

package com.sun.enterprise.config.backup.phase;

import com.sun.enterprise.config.backup.status.RestoreStatus;
import com.sun.enterprise.config.backup.status.SnapShotStatus;
import com.sun.enterprise.config.backup.status.Status;
import com.sun.enterprise.config.backup.status.StatusConstants;
import com.sun.enterprise.config.backup.StatusRegistry;
import com.sun.enterprise.config.backup.utils.LoggerHelper;
import com.sun.enterprise.config.backup.pluggable.BackupStorage;
import com.sun.enterprise.config.backup.BackupAbortException;
import com.sun.enterprise.config.backup.BackupException;
import com.sun.enterprise.config.backup.utils.BackupHelper;
import com.sun.enterprise.config.backup.utils.FactoryHelper;
import com.sun.enterprise.config.backup.utils.LocalStringsHelper;
import java.io.File;
import java.io.IOException;

/**
 *
 * @author  sridatta
 */
public class RestorePhases extends PhasesBase {
    
    /** Creates a new instance of BackupPhases */
    public RestorePhases() {
    }
    
   /* public void assertStatusNotFailed(BackupStatus bs) {
        assertNotNull(bs);
        assertNotFailed(bs);
    }
    */
    
    public void assertStatusNotNull(RestoreStatus rs) {
        if(rs == null) {
            LoggerHelper.info("null_status_in_restore");
            //should never happen
            RestoreStatus rs1 = new RestoreStatus();
            setStatusInRegistry(rs1);
            
            throw new BackupAbortException(
                "error_invoking_restore",
                LocalStringsHelper.getString("error_invoking_restore"));
        }
    }
    
    public RestoreStatus getStatus() {
        return (RestoreStatus)getStatusFromRegistry();
    }
    
    public void monitorBackupDir() {
        try {
            FactoryHelper.getBackupStorageMonitor().run();
        } catch(Exception e) {
            //log it
            LoggerHelper.warning("error_monitoring_backup_dir");
            LoggerHelper.fine("error_monitoring_backup_dir", e);
        }
    }
    
    /*
    
    public void setBackupFileSize(long size) {
          getStatus().setBackupFileSize(size);
    }
    
     */
    //restore methods
     
    /**
     * history is not maintained for snapshots. It is done internally
     * through the system
     */
    public void takeSnapShot() {
        try {
           // String absSnapShotFileName = BackupHelper.getAbsoluteSnapshotFileName();
            SnapShotStatus ss = new SnapShotStatus(true);
            long size = backup(ss.getAbsoluteSnapShotFileName(), ss);
            ss.setStatusCode(StatusConstants.STATUS_SUCCESS);
            LoggerHelper.fine("snapshot info= " + ss);
            FactoryHelper.getSnapShotStorageMonitor().run();
        } catch(Exception e1) {
            LoggerHelper.info("ignore_error_taking_snapshot ", e1);
        }
    }
    
    private long backup(String absSnapShotFileName, SnapShotStatus ss) throws Exception {
        String[] srcDirs = ss.getDirectoriesToBackup();
              LoggerHelper.fine("Source Directory for snapshot is " 
                                + BackupHelper.ArrayToString(srcDirs));
             
              //get the correct storage class
              BackupStorage backupStorage = FactoryHelper.getStorage();
              return backupStorage.backup(srcDirs, absSnapShotFileName);
    }
    
    public void performRestore(File f) throws Exception {
            FactoryHelper.getStorage().restore(f);
    }
    
    /** 
     * liquidate the target directories. note that
     * a snapshot is already taken
     */
    public void deleteTarget() {
        //FIXME NYI
            FactoryHelper.getStorage().deleteTarget();
    }
}
