/*
 * ZipWriter.java
 *
 * Created on December 19, 2003, 11:39 PM
 */

package com.sun.enterprise.config.backup.pluggable.impl;

import java.io.IOException;
import java.io.File;
import com.sun.enterprise.config.backup.BackupException;
import com.sun.enterprise.config.backup.BackupAbortException;
import com.sun.enterprise.config.backup.status.Status;
import com.sun.enterprise.config.backup.utils.FactoryHelper;
import com.sun.enterprise.config.backup.utils.LoggerHelper;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.zip.ZipWriter;
import com.sun.enterprise.util.zip.ZipFileException;
import com.sun.enterprise.util.StringUtils;

import com.sun.enterprise.config.backup.pluggable.BackupStorage;
/**
 *
 * @author  sridatta
 */
public class ZipStorage extends GenericStorage 
{
	/**
	* creates a zip file in the specified directory
	* @return int size of the zip that was just created
	*/
	long copyFiles(File fromDir, File toDir) throws BackupException
	{
		File zip = new File(toDir.getAbsolutePath() + ".zip");
		LoggerHelper.fine("Writing " + zip.getPath());
		
		try
		{
			ZipWriter writer = new ZipWriter(zip.getPath(), fromDir.getPath());
			writer.safeWrite();
			return zip.length();
		}
		catch(ZipFileException zfe)
		{
			throw new BackupException("Zip Backup Error", "Got a ZipFileException", zfe);
		}
	}
}
