/*
 * BackupStatus.java
 *
 * Created on December 13, 2000, 6:52 AM
 */

package com.sun.enterprise.config.backup.status;

import java.util.Date;
import com.sun.enterprise.config.backup.BackupException;
import com.sun.enterprise.config.backup.utils.BackupHelper;
import com.sun.enterprise.config.backup.utils.FactoryHelper;

/**
 * Backup Status is used to keep the status for 
 * the backup action. 
 * @author  sridatta
 */
public class SnapShotStatus extends Status {

        
        /** file used to restore or backed up file name */
    //private String _snapShotFileName;
    private String _absSnapShotFileName;
   
    /** directory where the backup file is stored .
     */
    /** timestamp of the backed up file 
     */
  //  private long _snapShotTimeStamp;
    
    /** Size of the backup file */
    private long _snapShotFileSize;
    
    /** Creates a new instance of BackupStatus */
    public SnapShotStatus() {
    }
    
    public SnapShotStatus(boolean init) throws BackupException {
        super(true);
        if(init) {
            init();
        }
    }
    private void init()  throws BackupException {
      //  setBackupDirectory(getDirectory());
       // long ts = System.currentTimeMillis();
       // setSnapShotTimeStamp(ts);
        setAbsoluteSnapShotFileName(getAbsoluteName(getCreationTimeStamp()));
    }

    public String getOperation() {
        return "snapshot";
    }
    
    /*
    protected String getDirectory() throws BackupException {
        return FactoryHelper.getEnv().getDirectoryToStoreSnapshotFile();
    }
     */
    
    /*
    protected String getRelativeName(long ts) throws BackupException {
        return BackupHelper.getRelativeSnapShotFileName(ts);
    }
     */
    
    protected String thisToString() {
        return "SnapShotFileName= " + _absSnapShotFileName;
    }
    
    public String getAbsoluteSnapShotFileName() {
        return _absSnapShotFileName;
    }
    
    private void setAbsoluteSnapShotFileName(String name) {
        _absSnapShotFileName = name;
    }
    
    private String getAbsoluteName(long ts) {
        return BackupHelper.getAbsoluteSnapshotFileName(ts);
    }
    
     public String[] getDirectoriesToBackup() {
        return FactoryHelper.getEnv().getDirectoriesToBackup();
    }
     
}
