/*
 * Status.java
 *
 * Created on December 13, 2000, 6:21 AM
 */

package com.sun.enterprise.config.backup.status;

import java.io.Serializable;
import java.util.Date;
import com.sun.enterprise.config.backup.BackupException;
import com.sun.enterprise.config.backup.utils.FactoryHelper;

/**
 * This class is the parent class for BackupStatus
 * and Restore Status. It is used to store
 * detailed information about the status of
 * an operation.
 * 
 * Implements StatusConstants and Serializable
 *
 * @author  sridatta
 */
public abstract class Status implements StatusConstants, Serializable {
    
    private StatusCode _statusCode = new StatusCode();
    private Exception _exception;
    private ExecutionType _executionType = new ExecutionType();
    private long _creationTimeStamp = System.currentTimeMillis();
    /** can be  a directory or zip */
    private String _backupStorageType;

    private String _extraInfo;
    
    /** Creates a new instance of Status */
    public Status() {
    }
    
    public Status(boolean initialize) throws BackupException {
        if(initialize) {
            init();
        }
    }
    
            /**
     * Determine the next number to be created
     * Managed the max numbers.
     * Delete the oldest one if required
     * get the prefix
     * add timestamp
     * create fileName = dir/prefix + timestamp+ number
     *
     * Update BackupNumber, TargetFile in BackupStatus
     * update source files, etc
     */
    private void init()  throws BackupException {
        setExecutionType(FactoryHelper.getEnv().getExecutionType());
        setBackupStorageType(FactoryHelper.getEnv().getBackupStorageType());
    }
    
    public long getCreationTimeStamp() {
        return _creationTimeStamp;
    }
    
    
    public String getBackupStorageType() {
        return _backupStorageType;
    }
    
    public void setBackupStorageType(String type) {
        _backupStorageType = type;
    }
    public String getStatusCode() {
        return _statusCode.getStatusCode();
    }
    
    public Exception getException() {
        return _exception;
    }
    
    public String getExecutionType() {
        return _executionType.getExecutionType();
    }
    
   public void setStatusCode(String status) throws BackupException {
        _statusCode.setStatus(status);
   }
   
   public void setExecutionType(String executionType) throws BackupException {
       _executionType.setExecutionType(executionType);
   }
   
   public void setException(Exception e) throws BackupException {
       _exception = e;
       _statusCode.setStatus(STATUS_FAILURE);
   }
 
   private String baseToString() {
       
       String exceptionMessages = (_exception == null)?"":
           ", ExceptionType= " + _exception.getClass().getName() +
           ", ExceptionMessage= " + _exception.getMessage();
           
       String creationTime = ", Created Time= " + getCreationDate();
       String result = 
            getOperation() + ":Status= " + _statusCode +
            ", ExecutionType= " + _executionType +
            ", Backup File Type " + _backupStorageType  +

            exceptionMessages + creationTime;

       return result;
   }
   
   public String toString() {
      String result = " {" +
        baseToString() + ", " +
        thisToString() +
        "}";
      return result;
    }
   
   private String getCreationDate() {
      return new Date(_creationTimeStamp).toString();    
   }
   
   public boolean isSuccess() {
       return STATUS_SUCCESS.equals(_statusCode.getStatusCode());
   }
   
   public String getExtraInfo() {
       return _extraInfo;
   }
   
   public void setExtraInfo(String s) {
       _extraInfo = s;
   }
   
   public abstract String getOperation();
   protected abstract String thisToString();
}
