# -*- coding: utf-8 -*-

import os, os.path
import gettext

DOMAIN = 'glchess'
gettext.bindtextdomain(DOMAIN)
gettext.textdomain(DOMAIN)

from gettext import gettext as _
import gtk.glade

gtk.glade.bindtextdomain(DOMAIN)
gtk.glade.textdomain(DOMAIN)

VERSION = '1.0'
APPNAME = _("glChess")

COPYRIGHT     = _('Copyright 2005-2006 Robert Ancell (and contributors)')
DESCRIPTION   = _('A 2D/3D chess interface for Gnome')
WEBSITE       = 'http://glchess.sourceforge.net'
WEBSITE_LABEL = _('glChess homepage')
AUTHORS       = ['Robert Ancell <bob27@users.sourceforge.net>']
ARTISTS       = ['John-Paul Gignac (3D Models)', 'Max Froumentin (2D Models)', 'Hylke Bons <h.bons@student.rug.nl> (icon)']
TRANSLATORS   = u"""Luca Marturana <lucamarturana@gmail.com> (It)
Hakan Bekdas <hakanbekdas@yahoo.com> (tr)
A S Alam <apbrar@gmail.com> (pa)
Michał Bentkowski <mr.ecik@mail.com> (pl)
Daniel Nylander <po@danielnylander.se> (sv)
Translators on Rosetta (launchpad.net)
Gnome Translation Team"""
LICENSE = """This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License version 2 as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details. 

You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

2D Models:
Copyright World Wide Web Consortium, (Massachusetts Institute of Technology, Institut National de Recherche en Informatique et en Automatique, Keio University). All Rights Reserved. http://www.w3.org/Consortium/Legal/"""

APP_DATA_DIR    = '/usr/share/games/'
BASE_DIR        = '/usr/share/games/glchess/'
DATA_DIR        = os.path.expanduser('~/.glchess/')
CONFIG_FILE     = os.path.join(DATA_DIR, 'config.xml')
LOCAL_AI_CONFIG = os.path.join(DATA_DIR, 'ai.xml')

# If running from the glChess development directory then use local files
if os.path.isfile('.glchess_devel'):
    print '*** Using development data files ***'
    GLADE_DIR = 'glade/'
    TEXTURE_DIR = 'data/textures/'
else:
    GLADE_DIR = '/usr/share/games/glchess/gui/'
    TEXTURE_DIR = '/usr/share/games/glchess/textures/'

def initialize_games_dir ():
    if not os.path.exists(DATA_DIR): os.makedirs(DATA_DIR)
