/* glfer.h
 * 
 * Copyright (C) 2001-2003 Claudio Girardi
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA, 02111-1307, USA
 */

#ifndef _GLFER_H_
#define _GLFER_H_

#include <gtk/gtk.h>

#define RELDATE "25 Aug 2003"

#ifndef	FALSE
#define	FALSE	(0)
#endif

#ifndef	TRUE
#define	TRUE	(!FALSE)
#endif

#define	QRSS 1
#define	DFCW 2

#define	DEV_SERIAL 0
#define	DEV_PARALLEL 1

enum
{ SCALE_LIN, SCALE_LOG };

enum
{ MODE_NONE = -1, MODE_FFT, MODE_MTM, MODE_HPARMA };

enum
{ HSV, THRESH, COOL, HOT, BW, BONE, COPPER, OTD, PALETTES };

/* function prototypes */
void show_message(gchar * fmt, ...);


typedef struct
{
  char *program_name;		/* the name used for invoking the program */
  int mode;			/* current mode */
  int scale_type;		/* display scale type */

  int fft_n;			/* number of samples used for the FFT */
  float fft_overlap;		/* overlap between FFT blocks */
  float fft_a;                  /* RA9MB nonlinear processing parameter */
  int fft_limiter;              /* enable limter */

  int mtm_n;			/* number of samples used for the MTM FFT */
  float mtm_overlap;		/* overlap between MTM FFT blocks */
  float mtm_w;			/* mtm window relative bandwidth (0 < w < 0.5) */
  int mtm_k;			/* number of windows to use */


  int hparma_n;			/* number of samples used for the MTM FFT */
  float hparma_overlap;		/* overlap between MTM FFT blocks */
  int hparma_t;			/* number of equations */
  int hparma_p_e;		/* number of poles */

  int window_type;		/* FFT window */
  int sample_rate;		/* sound card sample rate */
  float offset_freq;		/* frequency offset for spectrogram frequency scale */
  float dot_time;		/* dot duration */
  float dfcw_gap_time;		/* gap between dots duration in DFCW mode */
  int tx_mode;			/* transmission mode: QRSS or DFCW */
  float dash_dot_ratio;		/* dash to dot ratio in QRSS */
  float ptt_delay;		/* delay in key down after closing PTT */
  float sidetone_freq;		/* sidetone frequency */
  int sidetone;			/* optional sidetone enabled ? */
  float dfcw_dot_freq;		/* DFCW dot tone frequency */
  float dfcw_dash_freq;		/* DFCW dash tone frequency */
  char *ctrl_device;		/* device controlling KEY and PTT */
  int device_type;		/* control device type */
  char *audio_device;		/* device controlling KEY and PTT */
}
opt_t;


typedef struct
{
  GtkTooltips *tt;		/* tooltips */
  GtkWidget *qso_menu_item;
  GtkWidget *test_menu_item;
  int init_done;		/* start-up inizialization done */
  float cpu_usage;		/* CPU usage */
  int current_mode;		/* current mode */
}
glfer_t;

typedef struct
{
  double start;
  double stop;
  double delta;
}
perf_timer_t;


#endif /* #ifndef _GLFER_H_ */
