/* gLife - An Artificial Life implementation using GNOME
 *
 * Copyright (C) 1999 Ali Abdin <aliabdin@aucegypt.edu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */

typedef struct {
	gint maxmaxage;
	gint minmaxage;
	gboolean enforceage;

	gint numanimals;

	gint timeout;
	gboolean log2screen;

	gboolean gridcheck;
	gboolean terraincheck;
	gboolean animalcheck;

	gboolean enforcerep;
	gint minrepage;
	gint minfoodtorep; /* Minimum amount of food needed to reproduce */
	gint percenttochild; /* Percent of food to give to children */
} ConfigOptions;

extern ConfigOptions ruleset;

extern void start_simulation();
extern void restart_simulation(GtkWidget *, gpointer);
extern gint do_update(gpointer);
extern gboolean animal_exists (gint, gint);
