/*  Glimmer - properties.h
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _PROPERTIES_H_
#define _PROPERTIES_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "declarations.h"
#include "widgets/gdsfile.h"

typedef struct _props
{
    GtkWidget *over_ride;
    GtkWidget *dir;
    GtkWidget *bracketmatch;
    GtkWidget *syntax;
    GtkWidget *auto_indent;
    GtkWidget *use_spaces;
    GtkWidget *spaces_spin;
    GtkWidget *compiler;
    GtkWidget *debugger;
    GtkWidget *execution;
    GdsFileProperties *defaults;
    GdsFileProperties *current;
    GdsFileProperties *backups;
}FileProps;

void edit_properties(GtkWidget *widget, gpointer data);
void save_properties(GtkWidget *widget, FileProps *props);
void get_backup_props(GtkWidget *widget, FileProps *props);
void get_default_props(GtkWidget *widget, FileProps *props);
void redo_backup_props(GtkWidget *widget, FileProps *props);

void get_properties(FileProps *props, GdsFileProperties *source);
void put_properties(FileProps *props, GdsFileProperties *source);
void copy_properties(GdsFileProperties *dest, GdsFileProperties *source);
void kill_data(GtkWidget *widget, gpointer data);
void free_properties(GtkWidget *widget, GdsFileProperties *props);

#ifdef __cplusplus
}
#endif

#endif
