/*
 * Copyright 1999-2006 University of Chicago
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * globals.h
 *
 * rcsid = "$Header: /home/globdev/CVS/globus-packages/nexus/source/nexus/globals.h,v 1.52 2006/01/19 05:57:05 mlink Exp $"
 */

#ifndef _NEXUS_INCLUDE_GLOBALS_H
#define _NEXUS_INCLUDE_GLOBALS_H

/*
 * _nx_my_mi_proto
 *
 * initialized in pr_iface.c and used in gp.c
 */
NEXUS_GLOBAL nexus_mi_proto_t *_nx_my_mi_proto;

/*
 * _nx_local_proto
 *
 * nexus_proto_t* for the local protocol module
 */
static nexus_proto_t *_nx_local_proto;

NEXUS_GLOBAL char _nx_my_hostname[MAXHOSTNAMELEN];
/*
 * This is used by the Nexus print routines for output.
 */
NEXUS_GLOBAL FILE 	*_nx_stdout;


/*
 * _nx_master_id_string
 *
 * This is a string that is supplied by the master node which
 * uniquely identifies this Nexus computation.
 */
NEXUS_GLOBAL char *	_nx_master_id_string;


#ifdef BUILD_LITE

/*
 * _nx_lite_context
 *
 * Since NexusLite has only one context in a process, and no threads,
 * the nexus_context_t* is just stored in a global.
 */
NEXUS_GLOBAL nexus_context_t *_nx_lite_context;

#else

NEXUS_GLOBAL globus_callback_space_t _nx_serial_space;

#endif /* BUILD_LITE */

/*
 * _nx_context_key
 *
 * This key is used to store the context pointer in thread specific storage.
 */
NEXUS_GLOBAL globus_thread_key_t _nx_context_key;



/*
 * _nx_context_list
 *
 * This is a list of all the contexts within this nexus process
 */
NEXUS_GLOBAL nexus_context_t *_nx_context_list;


/*
 * _nx_initial_context
 * 
 * This is the first context that is created during process
 * initialization.
 */
NEXUS_GLOBAL nexus_context_t *_nx_initial_context;

/*
 * Various debug flags...
 */
#ifdef BUILD_DEBUG
NEXUS_GLOBAL int		    _nx_debug_level;
#endif /* BUILD_DEBUG */


/*
 * For pause points.
 *   _nx_pause_on_fatal==NEXUS_TRUE is Nexus should pause when it hits
 * 	a fatal error.
 *   _nx_pausing_for_fatal==NEXUS_TRUE after we have paused on fatal (used
 *	to avoid looping in the pause.
 */
NEXUS_GLOBAL nexus_bool_t	_nx_pause_on_fatal;
NEXUS_GLOBAL nexus_bool_t	_nx_pausing_for_fatal;


/*
 * _nx_fault_tolerant
 */
NEXUS_GLOBAL nexus_bool_t	_nx_fault_tolerant;

NEXUS_GLOBAL int		_nx_skip_poll_count;

NEXUS_GLOBAL globus_size_t      _nx_tcp_mim_msg_size;

/*
 * _nx_transform_table
 */
NEXUS_GLOBAL nexus_transform_table_t
			_nx_transform_table[NEXUS_TRANSFORM_TABLE_SIZE];

#endif /* _NEXUS_INCLUDE_GLOBALS_H */
