/*
 * Copyright 1999-2006 University of Chicago
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * mac_func.c
 *
 * Many of the Nexus functions can be efficiently implemented
 * as macros.  However, in some situations you may not want to use
 * the macros (i.e. when debugging).  If the user
 * defines USE_MACROS before including nexus.h, then the
 * macro versions will be used.
 *
 * This file holds the function versions of these various macros.
 */

static char *rcsid = "$Header: /home/globdev/CVS/globus-packages/nexus/source/nexus/mac_func.c,v 1.27 2006/01/19 05:57:05 mlink Exp $";

#include "internal.h"


/*
 * nexus_stdio_lock()
 */
#undef nexus_stdio_lock
void nexus_stdio_lock(void)
{
#if !defined(HAVE_THREAD_SAFE_STDIO) && !defined(BUILD_LITE)
    globus_stdio_lock();
#endif
} /* nexus_stdio_lock() */


/*
 * nexus_stdio_unlock()
 */
#undef nexus_stdio_unlock
void nexus_stdio_unlock(void)
{
#if !defined(HAVE_THREAD_SAFE_STDIO) && !defined(BUILD_LITE)
    globus_stdio_unlock();
#endif
} /* nexus_stdio_unlock() */


/*
 * nexus_endpoint_set_user_pointer()
 */
#undef nexus_endpoint_set_user_pointer
void nexus_endpoint_set_user_pointer(nexus_endpoint_t *endpoint, void *address)
{
    nexus_macro_endpoint_set_user_pointer(endpoint, address);
} /* nexus_endpoint_set_user_pointer() */


/*
 * nexus_endpoint_get_user_pointer()
 */
#undef nexus_endpoint_get_user_pointer
void *nexus_endpoint_get_user_pointer(nexus_endpoint_t *endpoint)
{
    return(nexus_macro_endpoint_get_user_pointer(endpoint));
} /* nexus_endpoint_get_user_pointer() */


/*
 * nexus_startpoint_set_null()
 */
#undef nexus_startpoint_set_null
void nexus_startpoint_set_null(nexus_startpoint_t *sp)
{
    nexus_macro_startpoint_set_null(sp);
} /* nexus_startpoint_set_null() */


/*
 * nexus_startpoint_is_null()
 *
 * Return non-zero if gp is a NULL global pointer, otherwise return zero.
 */
#undef nexus_startpoint_is_null
int nexus_startpoint_is_null(nexus_startpoint_t *sp)
{
    return (nexus_macro_startpoint_is_null(sp));
} /* nexus_startpoint_is_null() */
