/*
 * Copyright (C) 2000-2014  Innocent De Marchi
 * email: tangram.peces@gmail.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include "funcions.h"

#include <QtGui>


#include "configuracio.h"
#include "constants.h"
#include "conjuntpeces.h"


QString directoriFiguresPersonals(){
    QDir dirArxiu(QDir::homePath ());
    if (!dirArxiu.exists(DIR_ARXIUS_FIGURES_PERSONALS)){
         dirArxiu.mkdir(DIR_ARXIUS_FIGURES_PERSONALS);
      }
 return QDir::homePath ()+QDir().separator()+DIR_ARXIUS_FIGURES_PERSONALS;
}

QString directoriFiguresGeneradesAtzar(){
    QDir dirArxiu(directoriFiguresPersonals());
    if (!dirArxiu.exists("auto")){
         dirArxiu.mkdir("auto");
      }
return QDir::homePath ()+QDir().separator()+DIR_ARXIUS_FIGURES_PERSONALS
        +QDir().separator()+"auto";
}

QString filtreArxiusConcurs(Configuracio *confJoc){
return confJoc->tradueixCadena("Concurs")+" (*."+
                   confJoc->arxiuDadesFigures.mid(0,
                           confJoc->arxiuDadesFigures.lastIndexOf("."))+
                           QString("%1)").arg(confJoc->nivellJoc) ;
}

QString extensioArxiuConcurs(Configuracio *confJoc){
 return "."+confJoc->arxiuDadesFigures.mid(0,
                           confJoc->arxiuDadesFigures.lastIndexOf("."))+
                           QString("%1").arg(confJoc->nivellJoc);
}

/*
  Noms dels arxius de les figures generades a l'atzar
  pel formulari de revisió i per la càrrega

  El nom comencarà amb el nom de l'arxiu de figures del tangram
  seguit de _ i el que vulgui l'usuari i l'extensió .fig
  */
QString filtreArxiusFiguresGeneradesAtzar(Configuracio *confJoc, int tipus){
QString tipusFig;
if(tipus==0){
   tipusFig="arxiu.figures";
}
else tipusFig="figures.noves";

/*QString returnValor="("+confJoc->arxiuDadesFigures+");;("+
        confJoc->arxiuDadesFigures.mid(0,
        confJoc->arxiuDadesFigures.lastIndexOf("."))+"-*.fig)";
qCritical("%s", qPrintable(returnValor));*/

//return confJoc->tradueixCadena(tipusFig)+" ("+confJoc->arxiuDadesFigures+")";

/*25/04/14 El filtre no funcionava bé amb els noms d'arxius que compartien
 * part del nom. Ara es filtren els arxius amb el nom exacte corresponent
 * al tangram i amb el sufix -*.fig*/
  return  "("+confJoc->arxiuDadesFigures+");;("+
       confJoc->arxiuDadesFigures.mid(0,
       confJoc->arxiuDadesFigures.lastIndexOf("."))+"-*.fig)";

}

QString extensioArxiuFiguresGeneradesAtzar(Configuracio *confJoc){
return "."+confJoc->arxiuDadesFigures.mid(0,
                              confJoc->arxiuDadesFigures.lastIndexOf("."))+
                              QString("%1").arg(confJoc->nivellJoc);
}

/*
retorna la suma de tots els nombres entre
nombre i 1
*/
int sumatori(int nombre){
    /*int sumatori=0;
    for(int i=1;i<nombre;i++){
        sumatori=sumatori+i;
    }*/
    return ((nombre*(nombre-1))/2);
}

/*
Retorna el icone corresponent al nivel de dificultat
de la figura
*/
QIcon iconeFigura(int tipus){
switch(tipus){
     case 1:
       return QIcon(directoriLinux()+QDir().separator()+"images"+QDir().separator()+"facil.png");
     //  return QIcon(":/images/facil.png");
       break;
     case 2:
       return QIcon(directoriLinux()+QDir().separator()+"images"+QDir().separator()+"mitja.png");
      // return QIcon(":/images/mitja.png");
       break;
     case 3:
       return QIcon(directoriLinux()+QDir().separator()+"images"+QDir().separator()+"dificil.png");
    //   return QIcon(":/images/dificil.png");
       break;
     case 4:
       return QIcon(directoriLinux()+QDir().separator()+"images"+QDir().separator()+"ok.png");
     //  return QIcon(":/images/ok.png");
       break;
     default:
       return QIcon(directoriLinux()+QDir().separator()+"images"+QDir().separator()+"facil.png");
      // return QIcon(":/images/facil.png");
   }
}

/*
  Directoris linux
  21/04/11
  Modificat per permetre la coexistència de l'aplicació instal·lada
  i el codi font
 */
QString directoriLinux(){

 QDir dirArxiu;
  if (dirArxiu.exists(QCoreApplication::applicationDirPath()+ QDir().separator()+
                      "images")){
      return QCoreApplication::applicationDirPath();
  }
  else if (dirArxiu.exists("/usr/share/games/glpeces")){
      return "/usr/share/games/glpeces";
   }
  else return QCoreApplication::applicationDirPath();
 /*
 qCritical("Directori palicacio: %s", qPrintable(QCoreApplication::applicationDirPath()));
 QString dirInicial=QCoreApplication::applicationDirPath().replace(DIRECTORIS_LINUX_PROGRAMA,"");
 qCritical("Directori inicial: %s", qPrintable(dirInicial));
 dirInicial=dirInicial.append(DIRECTORIS_LINUX_AUXILIARS);
 qCritical("Directori inicial 2: %s", qPrintable(dirInicial));
 QDir dirArxiu;
    if (dirArxiu.exists(DIRECTORIS_LINUX)){
       return DIRECTORIS_LINUX;
    }
    else if (dirArxiu.exists(dirInicial)){
        return dirInicial;
    }
    else return QCoreApplication::applicationDirPath();
    */
}

/*
  13/02/11
  Carrega el contingut de l'arxiu passat per paràmetre
  a una llista (que retorna)
  */
QStringList llegeixArxiuALlista(QString arxiu){
    //obrim l'arxiu de jocs
    QFile arxiuData(arxiu);
    QStringList  dadesArxiu;
    if (arxiuData.open(QIODevice::ReadOnly | QIODevice::Text)){
     QTextStream entrada(&arxiuData);
     QString linia0 = entrada.readLine();
     while (!linia0.isNull()) {
         if ( ! (linia0.mid(0,1)=="#") ){
            dadesArxiu.append(linia0);
         }
       linia0 = entrada.readLine();
     } //final del while de la lectura de l'arxiu
 }
 return dadesArxiu;
}

QString llegeixLiniaArxiu(QString arxiu, int linia){
    //obrim l'arxiu de jocs
    QFile arxiuData(arxiu);
    QString linia0;
    //QString  dadesArxiu;
    if (arxiuData.open(QIODevice::ReadOnly | QIODevice::Text)){
     QTextStream entrada(&arxiuData);
     linia0 = entrada.readLine();
     int numeroLinia=1;
     while ( (!linia0.isNull())
         && (numeroLinia<linia) ) {
         linia0 = entrada.readLine();
         numeroLinia++;
         }
     } //final del while de la lectura de l'arxiu
 return linia0;
}

/*
  Genera els directoris necessaris per la generació
  dels arxius html
  */
void directorisHTML(QString dir){
    QDir dirHTML(directoriFiguresPersonals()+QDir().separator()+"html");
    if (!dirHTML.exists()){
         dirHTML.mkdir(directoriFiguresPersonals()+QDir().separator()+"html");
      }
    QDir dirImatge(directoriFiguresPersonals()+QDir().separator()+"html");
    if (!dirImatge.exists("img")){
         dirImatge.mkdir(directoriFiguresPersonals()+QDir().separator()+"html"+QDir().separator()+"img");
      }
    QDir dirArxiu(directoriFiguresPersonals()+QDir().separator()+"html"+QDir().separator()+"img");
    if (!dirArxiu.exists(dir)){
         dirArxiu.mkdir(dir);
      }
    //directori pels arxius latex
    QDir dirLatex(directoriFiguresPersonals()+QDir().separator()+"latex");
    if (!dirLatex.exists()){
         dirLatex.mkdir(directoriFiguresPersonals()+QDir().separator()+"latex");
      }
}
/*
  Retorna un nombre l'atzar a partir del passat
  com a parámetre
  */
int generaNombreAtzar(int llavor){
    qsrand(llavor);
    return qrand();
}

/*
  Retorna la diferència de longitud de les siluetes,
  com a percentatge de la longitud de la silueta
  amb major longitud
  */
qreal comparacioLongitudSiluetesPercentatge(qreal longitud1,qreal longitud2){
    qreal minim,Maxim;
    if(longitud1<=longitud2){
       minim= longitud1;
       Maxim= longitud2;
    }
    else{
        minim= longitud2;
        Maxim= longitud1;
    }
    return ((Maxim-minim)*100)/minim;
}

/*
  Comprova que els centres de les figures dels dos
  conjunts de peces estiguin uns dins dels altres
  */
bool comprovaCentresFigures(ConjuntPeces *conjunt1,
                                             ConjuntPeces *conjunt2){
 int numeroCentresCorrectes=0;
 int descomptarCentre=0;
 for(int k=0;k<conjunt1->arrayPeces.size();k++){
 QPointF centrePeca=conjunt1->arrayPeces[k]->pos()+
         conjunt1->arrayPeces[k]->centreRectanglePeca();
 //Si el centre de la peça està dins de la peça, el comprovam
 if (conjunt1->arrayPeces[k]->shape().contains(
         conjunt1->arrayPeces[k]->centreRectanglePeca())){
  for(int i=0;i<conjunt2->arrayPeces.size();i++){
          if( conjunt2->arrayPeces[i]->shape().contains(
                  centrePeca-conjunt2->arrayPeces[i]->pos())
              ){
              numeroCentresCorrectes=numeroCentresCorrectes+1;
              break;
          }
      }
    }
 else descomptarCentre=descomptarCentre+1;
}
return numeroCentresCorrectes==conjunt1->arrayPeces.size()-descomptarCentre;
}
/*
  Permet seleccionar un color per la peça
  i escriu la selecció a l'arxiu de configuració
  */
QColor personalitzaColorPeca(int indexEnElConjunt,
                             QColor colorOrig, int pTipusTangram){
    QColor color;
    color = QColorDialog::getColor(Qt::green);
    if ( (color.isValid()) && (color != Qt::white) ) {
      desaColorsPecaPersonalitzat(QString("%1/%2")
                                  .arg(pTipusTangram).arg(indexEnElConjunt),
                                  color.name());
      return color;
    }
    else return colorOrig;
}

void eliminaPersonalitzaColorPeca(int indexEnElConjunt,
                                  int ptipusTangram){
    QSettings *configArxiu=new QSettings(QSettings::IniFormat,
                                  QSettings::UserScope,"De Marchi", "Peces");
    configArxiu->remove(QString("%1/%2")
                        .arg(ptipusTangram)
                        .arg(indexEnElConjunt));
}

void desaColorsPecaPersonalitzat(QString clau,QString color){
QSettings *configArxiu=new QSettings(QSettings::IniFormat,
                              QSettings::UserScope,"De Marchi", "Peces");
configArxiu->setValue(clau,color);
}


/* Retorna la distància entre els dos punts passats
 */
double distanciaEntrePunts(QPointF punt1,QPointF punt2){
  return sqrt(pow(punt1.x()-punt2.x(),2)+pow(punt1.y()-punt2.y(),2)) ;
}


/* Retorna el sentit del gir que cal donar a una peça
 * depenent de si el punt2 està a la dreta o l'esquerra
 * del punt central de la peça
 */
int sentitDelGir(QPointF centrePeca,QPointF punt){
    if (punt.x()-centrePeca.x()>=0){
        return 1;
    }
    else return -1;
}

/* fa una pausa en milisegons*/
void pausa(int temps){
  //QTest::qSleep(temps);
  qApp->processEvents();
}
