open Gdome;;

exception Impossible

let di = domImplementation ()

let doc = di#createDocumentFromURI ~uri:(Sys.argv.(1)) ()
(*let _ = di#disableEvent doc "*"*)

let stupid_clone (doc : Gdome.document) =
  ignore (di#saveDocumentToFile ~doc:doc ~name:"tmp.xml" ~indent:false ()) ;
  (di#createDocumentFromURI ~uri:"tmp.xml" ())

let smart_clone (doc : Gdome.document) =
  let rec clone_node (n : Gdome.node) =
    match n#get_nodeType with
      GdomeNodeTypeT.ELEMENT_NODE -> clone_element (new Gdome.element_of_node n)
    | GdomeNodeTypeT.TEXT_NODE -> clone_text n
    | _ -> raise Impossible
  and clone_element (el : Gdome.element) =
    let el' = doc#createElement (el#get_nodeName) in
    clone_siblings el#get_firstChild el' ;
    (el' :> Gdome.node)
  and clone_text (n : Gdome.node) =
    let v = 
      match n#get_nodeValue with
        Some s -> s
      | None -> raise Impossible
    in
    let n' = doc#createTextNode v in
    (n' :> Gdome.node)
  and clone_siblings n el' =
    match n with
      Some n' ->
        ignore (el'#appendChild (clone_node n'));
	clone_siblings n'#get_nextSibling el'
    | None -> ()
  in 
  let root = doc#get_documentElement in
  ignore (doc#removeChild (root :> Gdome.node)) ;
  ignore (doc#appendChild ((clone_element root) :> Gdome.node)) ;
  (* ignore (doc#replaceChild ((clone_element root) :> Gdome.node) (root :> Gdome.node)) ; *)
  doc

let _ =
  let t2 = Sys.time () in
  let doc2 = smart_clone doc in
  let t3 = Sys.time () in
  prerr_endline ("T1: " ^ (string_of_float (t3 -. t2)))

