/*
 * Copyright 2008 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.gmetrics.metric

import org.codehaus.groovy.ast.GroovyClassVisitor
import org.gmetrics.source.SourceCode

/**
 * Interface for Groovy AST Visitors
 *
 * @author Chris Mair
 * @version $Revision: 77 $ - $Date: 2010-02-20 20:28:26 -0500 (Sat, 20 Feb 2010) $
 */
interface AstVisitor extends GroovyClassVisitor {

    /**
     * Set the SourceCode associated with this visitor
     * @param sourceCode - the SourceCode
     */
    public void setSourceCode(SourceCode sourceCode)

}