/*
 *    ptt.c  --  PTT control
 *
 *    Copyright (C) 2001, 2002, 2003
 *      Tomi Manninen (oh2bns@sral.fi)
 *
 *    This file is part of gMFSK.
 *
 *    gMFSK is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    gMFSK is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with gMFSK; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>

#include "main.h"
#include "ptt.h"
#include "hamlib.h"
#include "cwirc.h"

static gint pttfd = -1;
static gint pttinv = 0;
static gint pttarg = TIOCM_RTS | TIOCM_DTR;
static gchar *pttpath = NULL;

void init_ptt(const gchar *path, gint inverted, gint mode)
{
	if (cwirc_extension_mode)
		return;

	/* If it's open then close it */
	if (pttfd != -1) {
		close(pttfd);
		pttfd = -1;
	}

	pttinv = inverted;

	switch (mode) {
	case 0:
		pttarg = TIOCM_RTS;
		break;
	case 1:
		pttarg = TIOCM_DTR;
		break;
	case 2:
		pttarg = TIOCM_RTS | TIOCM_DTR;
		break;
	}

	g_free(pttpath);

	if (!strcasecmp(path, "none"))
		pttpath = NULL;
	else
		pttpath = g_strdup(path);
}

static void open_ptt(void)
{
	if (cwirc_extension_mode)
		return;

	if (!pttpath)
		return;

	if ((pttfd = open(pttpath, O_RDWR, 0)) < 0)
		errmsg("Cannot open PTT device '%s': %m", pttpath);
}

void set_ptt(gint ptt)
{
	int arg = pttarg;

	if (cwirc_extension_mode)
		return;

#if WANT_HAMLIB
	/* try hamlib ptt first */
	hamlib_set_ptt(ptt);
#endif

	/* If it's closed, try to open it */
	if (pttfd == -1)
		open_ptt();

	/* Couldn't open it? Oh well... */
	if (pttfd == -1)
		return;

	if (pttinv)
		ptt = !ptt;

	if (ioctl(pttfd, ptt ? TIOCMBIS : TIOCMBIC, &arg) < 0)
		errmsg("set_ptt: ioctl: %m");
}

