/*
 *    snd.h  --  Sound card routines.
 *
 *    Copyright (C) 2001, 2002, 2003
 *      Tomi Manninen (oh2bns@sral.fi)
 *
 *    This file is part of gMFSK.
 *
 *    gMFSK is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    gMFSK is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with gMFSK; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef _SND_H
#define _SND_H

#ifdef __cplusplus
extern "C" {
#endif

#define	SOUND_TESTMODE_NONE	0
#define	SOUND_TESTMODE_RX	1
#define	SOUND_TESTMODE_TX	2
#define	SOUND_TESTMODE_BOTH	(SOUND_TESTMODE_RX | SOUND_TESTMODE_TX)

extern void sound_set_conf(const gchar *, gboolean, gboolean, gboolean);

extern void sound_set_testmode(gint);

extern int sound_open_for_write(int srate);
extern int sound_open_for_read(int srate);

extern void sound_close(void);

extern int sound_write(float *buf, int count);
extern int sound_read(float *buf, int count);

extern char *sound_error(void);

#ifdef __cplusplus
}
#endif

#endif
