/* gmoo - a gtk+ based graphical MOO/MUD/MUSH/... client
 * Copyright (C) 1999-2000 Gert Scholten
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef GM_MISC_H
#define GM_MISC_H

/* Parses a comma seperated list in a string to a GList with newly malloc()ed
 * string elements
 */
GList *str_to_GList(const char *str);
GList *str_to_GList_sep(const char *str, char seperator);

/* Concats the entire glist into a newly allocated string */
char *GList_to_str(const GList *list);
char *GList_to_str_sep(const GList *list, char *seperator);

GList *get_lines_from_file(const char *filename);

/* ansi related stuff */
char *strip_ansi(const char *string, int len); /* needs to be free()ed */

/* returned in a newly allocated sting */
char *limit_string_to_length(const char *s, int length);

#define is_dir(d) exists_dir(d)
int exists_dir(const char *dirname);

char *str_tolower(char *s);

#endif /* GM_MISC_H */
