/* gmoo - a gtk+ based graphical MOO/MUD/MUSH/... client
 * Copyright (C) 1999-2000 Gert Scholten
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef GM_NOTEBOOK_H
#define GM_NOTEBOOK_H

#include "config.h"

/* Types that can be added in the notebook */
#define TK_NONE   -1      /* Used for the event of an empty notebook */
#define TK_WORLD  1 << 0
#define TK_EDITOR 1 << 1
#ifdef ZVT
#   define TK_RUN 1 << 2
#endif

/* General functions */
GtkWidget *gm_notebook_create     ();
int        gm_notebook_ok_to_close();
void       gm_notebook_close      ();
world     *gm_notebook_find_world (const char *name);

/* switching funcs */
void gm_notebook_next();
void gm_notebook_prev();
void gm_notebook_set (int page);

/* World functions */
int    gm_notebook_try_add_world      (const char *name);
void   gm_notebook_add_world          (world *w);
void   gm_notebook_close_world        (world *w);
void   gm_notebook_try_close_world    (world *w);
void   gm_notebook_close_worlds_with_name(const char *name);
void   gm_notebook_close_current_world();
world *gm_notebook_current_world      ();
world *gm_notebook_get_world_by_id    (int id);

/* editor functions */
void gm_notebook_remove_editor(editor_t *e);
void gm_notebook_add_type(int pos, int type, void *data,
                          GtkWidget *main, GtkWidget *tab);
void gm_notebook_append_type(int type, void *data,
                             GtkWidget *main, GtkWidget *tab);
                          
/* misc */
void   gm_notebook_close_current_tab();
void gm_notebook_set_tab_position(int position);
void gm_notebook_set_homogeneous_tabs(int on);
void gm_notebook_set_tabs_show_lines_waiting(int on);

GList *gm_notebook_get_worlds();

int gm_notebook_get_pos(void *page);

int gm_notebook_is_world(const void *data);

void gm_notebook_changed();

#include "run.h"
#ifdef ZVT
void gm_notebook_close_run(t_run_t *r);
#endif

void gm_notebook_save_status();
void gm_notebook_try_restore_status();

void gm_notebook_update_input_styles();

void gm_notebook_force_world_focused(world *w);

#endif /* GM_NOTEBOOK_H */
