.TH HOTSPOTTER GMTMANSECTION "1 Oct 2004" "GMT4.0" "GMT4.0"
.SH NAME
hotspotter \- Create CVA image from seamount flowlines
.SH SYNOPSIS
\fBhotspotter\fP [\fIinfile(s)\fP] \fB\-E\fP\fIstage_file\fP
\fB\-G\fP\fICVAgrid\fP \fB\-I\fP\fIx_inc\fP[\fBm|c\fP][/\fIy_inc\fP[\fBm|c\fP]]
\fB\-R\fP\fIwest/east/south/north\fP[\fBr\fP] [ \fB\-C\fP ] [ \fB\-D\fP\fIfactor\fP ] [ \fB\-F\fP ]
[ \fB\-H\fP[\fInrec\fP] ] [ \fB\-N\fP\fIupper_age\fP ]
[ \fB\-T\fP ] [ \fB\-V\fP ] [ \fB\-:\fP ] [ \fB\-bi\fP[\fBs\fP][\fIn\fP] ]
.SH DESCRIPTION
\fBhotspotter\fP reads (longitude, latitude, amplitude, radius, age) records
from \fIinfiles\fP [or standard input] and calculates flowlines using the
specified stage pole (Euler) rotations. These flowlines are convolved with
the shape of the seamount (using a Gaussian shape given amplitude and radius
= 6 sigma) and added up to give a Cumulative Volcano Amplitude grid (CVA).
See option \fB\-:\fP on how to read (latitude,longitude,...) files.
.br
        No space between the option flag and the associated arguments. Use upper case for the
option flags and lower case for modifiers.
.TP
\fIinfile(s)\fP
Data file(s) to be processed. If not given, standard input is read.
.TP
.B \-E
Give file with stage poles and opening angles. This file must contain
one record for each stage; each record must be of the following format:
.br
.sp
        lon lat tstart tstop ccw-angle
.br
.sp
where tstart and tstop are in Ma and the rest is in degrees. The oldest stage
must be listed first. tstart (tstop) is the age of the old (young) end of the
stage. Blank lines and records whose first column contains # will be ignored.
.SH OPTIONS
.TP
.B \-C
Expect Total Reconstruction Poles (Finite Poles) rather than Backward Stage Poles [Default]
File format is similar to the stage pole format except the youngest rotation must be listed
first and that the tstart column is optional (assumed to be 0 Ma).
.TP
.B \-D
Modify the sampling interval along flowlines. Default [0.5] gives approximately 2 points within
each grid box. Smaller factors gives higher resolutions at the expense of longer processing time.
.TP
.B \-F
Force pixel registration [Default is grid registration].
.TP
.B \-H
Input file(s) has Header record(s). Number of header records can be changed by editing
your \.gmtdefaults4 file. If used, \fBGMT\fP default is 1 header record. Use \fB\-Hi\fP
if only input data should have header records [Default will write out header records if the
input data have them].
.TP
.B \-N
Set the upper age to assign seamounts whose crustal age is unknown (i.e. NaN) [no upper age].
.TP
.B \-T
Truncate seamount ages exceeding the upper age set with \fB\-N\fP [no truncation].
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input and/or output. [Default is (longitude,latitude)].
Append \fBi\fP to select input only or \fBo\fP to select output only. [Default affects both].
.TP
.B \-bi
Selects binary input. Append \fBs\fP for single precision [Default is double].
Append \fIn\fP for the number of columns in the binary file(s).
.br
[Default is 5 input columns].
.SH EXAMPLES
To create a CVA image from the Pacific (x,y,z,r,t) data in the file seamounts.d,
using the DC85.d Euler poles, run
.br
.sp
\fBhotspotter\fP seamounts.d \fB\-E\fPDC85.d \fB\-G\fPCVA.grd \fB\-R\fP130/260/-66/60 \fB\-I\fP10\fBm \-N\fP145 \fB\-T \-V\fP
.br
.sp
This file can then be plotted with \fBgrdimage\fP.
.SH "SEE ALSO"
.IR gmt (GMTMANSECTION),
.IR grdimage (GMTMANSECTION),
.IR project (GMTMANSECTION),
.IR mapproject (GMTMANSECTION),
.IR backtracker (GMTMANSECTION),
.IR originator (GMTMANSECTION)
.SH REFERENCES
Wessel, P., 1999, "Hotspotting" tools released, EOS Trans. AGU, 80 (29), p. 319.
.br
