.TH GRDBLEND l "1 Nov 2006" "GMT4.1.4" "GMT4.1.4"
.SH NAME
grdblend \- Blend several partially over-lapping grids into one large grid
.SH SYNOPSIS
\fBgrdblend\fP \fIblendfile\fP \fB\-G\fP\fIgrdfile\fP \fB\-I\fP\fIxinc\fP[\fIunit\fP][\fB=\fP|\fB+\fP][/\fIyinc\fP[\fIunit\fP][\fB=\fP|\fB+\fP]] \fB\-R\fP\fIwest\fP/\fIeast\fP/\fIsouth\fP/\fInorth\fP[\fBr\fP] 
[ \fB\-N\fP\fInodata\fP ] [ \fB\-Q\fP ] [ \fB\-Z\fP\fIscale\fP ] 
[ \fB\-V\fP ] [ \fB\-W\fP ] [ \fB\-f\fP\fIcolinfo\fP ]
.SH DESCRIPTION
\fBgrdblend\fP reads a listing of gridded files and blend parameters and
creates a binary grdfile by blending the other grids using cosine-taper weights.
\fBgrdblend\fP will report if some of the nodes are not filled in with
data.  Such unconstrained nodes are set to a value specified by the user [Default is NaN].
Nodes with more than one value will be set to the weighted average value.
.TP
\fIblendfile\fP
ASCII file with one record per grid file to include in the blend.  Each record must contain the gridfile name,
the \fB\-R\fP-setting for the interior region, and the relative weight \fIwr\fP, separated by spaces or tabs.
In the combined weighting scheme, this grid will be given weight = zero outside its domain, weight = \fIwr\fP
inside the interior region, and a 2-D cosine-tapered weight between those end-members in the boundary strip.
However, if a negative \fIwr\fP is given then the sense of tapering is inverted (i.e., zero weight inside its
domain).
If the ASCII file is not given \fBgrdblend\fP will read standard input.
.TP
.B \-G
\fIgrdfile\fP is the name of the binary output grdfile.
.TP
.B \-I
\fIx_inc\fP [and optionally \fIy_inc\fP] is the grid spacing. Append \fBm\fP to
indicate minutes or \fBc\fP to indicate seconds.  If one of the units \fBe\fP, \fBk\fP, \fBi\fP,
or \fBn\fP is appended instead, the increment will be assumed to be in meter, km, miles, or
nautical miles, respectively, and will be converted to the equivalent degrees longitude at
the middle latitude of the region (the conversion depends on \fBELLIPSOID\fP).  If /\fIy_inc\fP is given but set to 0 it will be reset equal to
\fIx_inc\fP; otherwise it will be converted to degrees latitude.  If \fB=\fP is appended then
the corresponding max \fIx\fP (\fIeast\fP) or \fIy\fP (\fInorth\fP) may be slightly adjusted to fit exactly the given increment
[by default the increment may be adjusted slightly to fit the given domain].  Finally, instead
of giving an increment you may specify the \fInumber of nodes\fP desired by appending \fB+\fP to
the supplied increment; the increment is then recalculated from the number of nodes and the domain.
The resulting increment value depends on whether you have selected a gridline-registered or pixel-
registered grid; see Appendix B for details.
.TP
.B \-R
\fIxmin\fP, \fIxmax\fP, \fIymin\fP, and \fIymax\fP specify the Region of interest.  For geographic
regions, these limits correspond to \fIwest, east, south,\fP and \fInorth\fP and you may specify them
in decimal degrees or in [+-]dd:mm[:ss.xxx][W|E|S|N] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.  The two shorthands \fB\-Rg \-Rd\fP stand for global domain
(0/360 or -180/+180 in longitude respectively, with -90/+90 in latitude).
For calendar time coordinates you may either give relative
time (relative to the selected \fBTIME_EPOCH\fP and in the selected \fBTIME_UNIT\fP; append \fBt\fP to \fB\-JX|x\fP),
or absolute time of the form [\fIdate\fP]\fBT\fP[\fIclock\fP] (append \fBT\fP to \fB\-JX|x\fP).  At least one of \fIdate\fP and \fIclock\fP
must be present; the \fBT\fP is always required.  The \fIdate\fP string must be of the form [-]yyyy[-mm[-dd]]
(Gregorian calendar) or yyyy[-Www[-d]] (ISO week calendar), while the \fIclock\fP string must be of
the form hh:mm:ss[.xxx].  The use of delimiters and their type and positions must be as indicated
(however, input/output and plotting formats are flexible). 
.SH OPTIONS
.TP
.B \-N
No data.  Set nodes with no input grid to this value [Default is NaN].
.TP
.B \-Q
Create a header-less gridfile suitable for use with \fBgrdraster\fP.  Requires that the output gridfile
is a native format (i.e., not netCDF).
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-W
Do not blend, just output the weights used for each node.  This option is valid when only one
input grid is provided [Default makes the blend].
.TP
.B \-Z
Scale output values by \fIscale\fP before writing to file. [1].
.TP
.B \-f
Special formatting of input and output columns (time or geographical data).
Specify \fBi\fP(nput) or \fBo\fP(utput) [Default is both input and output].
Give one or more columns (or column ranges) separated by commas.
Append \fBT\fP (Absolute calendar time), \fBt\fP (time relative to chosen \fBTIME_EPOCH\fP),
\fBx\fP (longitude), \fBy\fP (latitude), or \fBf\fP (floating point) to each column
or column range item.  Shorthand \fB\-f\fP[\fBi\fP|\fBo\fP]\fBg\fP means \fB\-f\fP[\fBi\fP|\fBo\fP]0\fBx\fP,1\fBy\fP
(geographic coordinates).
.SH EXAMPLES
To create a grdfile from the four gridded files piece_?.grd, make the blendfile like this
.br
.sp
piece_1.grd	-R<subregion_1> 1
.br
piece_2.grd	-R<subregion_2> 1
.br
piece_3.grd	-R<subregion_3> 1
.br
piece_4.grd	-R<subregion_4> 1
.br
.sp
Then run
.br
.sp
\fBgrdblend\fP blend.job \fB\-G\fPblend.grd \fB\-R\fP<full_region> \fB\-I\fP<dx/dy> \fB-V\fP
.SH "SEE ALSO"
.IR GMT (l),
.IR grd2xyz (l),
.IR grdedit (l)
