.TH PSLEGEND l "1 Apr 2007" "GMT4.2.0" "GMT4.2.0"
.SH NAME
pslegend \- To plot a map legend
.SH SYNOPSIS
\fBpslegend\fP \fItextfile\fP \fB\-D\fP[\fBx\fP]\fIlon\fP/\fIlat\fP/\fIwidth\fP/\fIheight\fP/\fIjust\fP \fB\-J\fP\fIparameters\fP 
\fB\-R\fP\fIwest\fP/\fIeast\fP/\fIsouth\fP/\fInorth\fP[\fBr\fP] [ \fB\-C\fP\fIdx\fP/\fIdy\fP ] [ \fB\-F\fP ] 
[ \fB\-G\fP\fIfill\fP ] [ \fB\-K\fP ] [ \fB\-L\fP\fIspacing\fP ] [ \fB\-O\fP ] [ \fB\-P\fP ] 
[ \fB\-S\fP[\fIscript\fP] ] [ \fB\-U\fP[/\fIdx\fP/\fIdy\fP/][\fIlabel\fP] ] [ \fB\-V\fP ] [ \fB\-X\fP[\fBa\fP|\fBc\fP|\fBr\fP][\fIx-shift\fP[\fBu\fP]] ] [ \fB\-c\fP\fIcopies\fP ]
[ \fB\-Y\fP[\fBa\fP|\fBc\fP|\fBr\fP][\fIy-shift\fP[\fBu\fP]] ]
.SH DESCRIPTION
\fBpslegend\fP will make legends that can be overlaid on maps.  It reads specific
legend-related information from an input file [or stdin].  Because all the elements
of the legend can already be created with other tools (\fBpsxy\fP, \fBpstext\fP) we
use those tools by creating a batch job of commands that are executed to make the final
\fIPostScript\fP overlay.  Because of this process, the option exists to just output the script which
can then be fine-tuned manually.  Unless otherwise noted, annotations will be made using the
annotation font and size in effect.
.TP
\fItextfile\fP
This file contains instruction for the layout of items in the legend.  Each legend item is described by
a unique record.  All records begin with a unique character that is common to all records of the same
kind.  The order of the legend items is implied by the order of the records.  Ten different record types
are recognized, and the syntax for each of these records are presented below:
.TP
\fB#\fP Comment records
Records starting with # and blank lines are skipped.
.TP
\fBB\fP \fIcptname offset height\fP [ \fIoptional arguments\fP ]
The B record will plot a horizontal color bar, \fBpsscale\fP-style in the middle, starting at \fIoffset\fP from
the left edge, and of the given \fIheight\fP.  You may add any additional \fPpsscale\fP options from the list:
\fB\-A \-B \-E \-I \-L \-M \-N \-S \fPand \fB\-Z\fP.
.TP
\fBC\fP \fItextcolor\fP
The C record specifies the color with which the remaining text is to be printed.
\fItextcolor\fP can be in the form \fIr/g/b\fP, \fIc/m/y/k\fP, or a named color.
.TP
\fBD\fP \fIoffset pen\fP
The D record results in a horizontal line across the legend.  The line starts and stops \fIoffset\fP
units from the frame sides, and is drawn using the specified \fIpen\fP.
.TP
\fBG\fP \fIgap\fP
The G record specifies a vertical gap of the given length.  In addition to the standard units (\fBi, c, p\fP) you
may use \fBl\fP for lines.
.TP
\fBH\fP \fIfontsize font Header\fP
The H record plots a centered text string using the specified font parameters.
.TP
\fBI\fP \fIimagefile width justification\fP
Place an EPS or Sun raster image in the legend justified relative to the current point.  The
image \fIwidth\fP determines the size of the image on the page.
.TP
\fBL\fP \fIfontsize font justification Label\fP
The L record plots a (L)eft, (C)entered, or (R)ight-justified text string using the specified font parameters.
.TP
\fBM\fP \fIslon\fP\fB|\fP- slat length\fP \fBf|p\fP [ \fB\-R\fP\fIw/e/s/n\fP \fB\-J\fP\fIparam\fP ]
Place a map scale in the legend.  Specify \fIslon slat\fP, the point on the map where the scale applies (\fIslon\fP
is only meaningful for certain oblique projections.  If not needed, you must specify - instead),
\fIlength\fP, the length of the scale in km (append \fBm\fP or \fBn\fP for miles or nautical miles), and
\fBf|p\fP for fancy or plain scale.  If the \fB\-R \-J\fP supplied to \fBpslegend\fP is different than the
projection needed for the scale, supply the optional \fB\-R \-J\fP settings as well.  Note that \fIlength\fP
can have \fI:label:just\fP appended, where \fIlabel\fP replaces the default label (unless - is given) and
\fIjust\fP (\fBl|r|t|b\fP) dictates where the label is placed [Default is \fBt\fP].  Use \fBu\fP to treat the
label as distance units appended to each annotation.
.TP
\fBN\fP \fIncolums\fP
Change the number of columns in the legend [1].
.TP
\fBS\fP \fIdx1 symbol size fill pen dx2 text\fP
Plots the selected symbol with specified size, fill, and outline.  The symbol is centered at \fIdx1\fP from the
left margin of the column, with the explanatory text starting \fIdx2\fP from the margin.  Use - if no fill
is required.  Two \fBpsxy\fP symbols front (f) and vector (v) require special attention.  You must prepend
the length of the desired item to the rest of the symbol argument; this will be used internally to set the
correct fault or vector length and will be stripped before passing the arguments to \fBpsxy\fP.
.TP
\fB>\fP <paragraph mode header for pstext>
Start a new text paragraph by specifying all the parameters needed (see \fBpstext \-M\fP description).  Note that
\fBpslegend\fP knows what all those values should be, so normally you can leave the entire record (after >) blank.
If you need to set at least one of the parameters directly, you must specify all and set the ones you want to leave
at their default value to -.
.TP
\fBT\fP \fIparagraph-text\fP
One or more of these T records with text must follow after the \fB>\fP record.
.TP
\fBV\fP \fIoffset pen\fP
The V record draws a vertical line between columns (if more than one) using the selected pen.  \fIoffset\fP is
analogous to the offset for the D records but in the vertical direction.
.TP
.B \-D
Positions the legend and specifies its size.  The \fIjust\fP is a 2-char justification string (see \fBpstext\fP)
that relates the given position to a point on the rectangular legend box.  If you want to specify the position
in projected units (i.e., inches or cm), use \fB\-Dx\fP.
.TP
.B \-J
Selects the map projection. Scale is UNIT/degree, 1:xxxxx, or width in UNIT (upper case modifier).
UNIT is cm, inch, or m, depending on the \fBMEASURE_UNIT\fP setting in \.gmtdefaults4, but this can be
overridden on the command line by appending \fBc\fP, \fBi\fP, or \fBm\fP to the scale/width value.
For map height, max dimension, or min dimension, append \fBh\fP, \fB+\fP, or \fB-\fP to the width,
respectively.
.br
More details can be found in the \fBpsbasemap\fP man pages.
.br
.sp
\fBCYLINDRICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jc\fP\fIlon0/lat0/scale\fP (Cassini)
.br
\fB\-Jj\fP\fIlon0/scale\fP (Miller)
.br
\fB\-Jm\fP\fIscale\fP (Mercator - Greenwich and Equator as origin)
.br
\fB\-Jm\fP\fIlon0/lat0/scale\fP (Mercator - Give meridian and standard parallel)
.br
\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP (Oblique Mercator - point and azimuth)
.br
\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP (Oblique Mercator - two points)
.br
\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP (Oblique Mercator - point and pole)
.br
\fB\-Jq\fP\fIlon0/scale\fP (Equidistant Cylindrical Projection (Plate Carree))
.br
\fB\-Jt\fP\fIlon0/scale\fP (TM - Transverse Mercator, with Equator as y = 0)
.br
\fB\-Jt\fP\fIlon0/lat0/scale\fP (TM - Transverse Mercator, set origin)
.br
\fB\-Ju\fP\fIzone/scale\fP (UTM - Universal Transverse Mercator)
.br
\fB\-Jy\fP\fIlon0/lats/scale\fP (Basic Cylindrical Projection) 
.br
.sp
\fBAZIMUTHAL PROJECTIONS:\fP
.br
.sp
\fB\-Ja\fP\fIlon0/lat0/scale\fP (Lambert)
.br
\fB\-Je\fP\fIlon0/lat0/scale\fP (Equidistant)
.br
\fB\-Jf\fP\fIlon0/lat0/horizon/scale\fP (Gnomonic)
.br
\fB\-Jg\fP\fIlon0/lat0/scale\fP (Orthographic)
.br
\fB\-Js\fP\fIlon0/lat0/\fP[\fIslat/\fP]\fIscale\fP (General Stereographic)
.br
.sp
\fBCONIC PROJECTIONS:\fP
.br
.sp
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP (Albers)
.br
\fB\-Jd\fP\fIlon0/lat0/lat1/lat2/scale\fP (Equidistant)
.br
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP (Lambert)
.br
.sp
\fBMISCELLANEOUS PROJECTIONS:\fP
.br
.sp
\fB\-Jh\fP\fIlon0/scale\fP (Hammer)
.br
\fB\-Ji\fP\fIlon0/scale\fP (Sinusoidal)
.br
\fB\-Jk\fP[\fBf|s\fP]\fIlon0/scale\fP (Eckert IV (f) and VI (s))
.br
\fB\-Jn\fP\fIlon0/scale\fP (Robinson)
.br
\fB\-Jr\fP\fIlon0/scale\fP (Winkel Tripel)
.br
\fB\-Jv\fP\fIlon0/scale\fP (Van der Grinten)
.br
\fB\-Jw\fP\fIlon0/scale\fP (Mollweide)
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jp\fP[\fBa\fP]\fIscale\fP[\fI/origin\fP][\fBr\fP|\fBz\fP] (Polar coordinates (theta,r))
.br
\fB\-Jx\fP\fIx-scale\fP[\fBd|l|p\fP\fIpow\fP\fB|t|T\fP][\fI/y-scale\fP[\fBd|l|p\fP\fIpow\fP\fB|t|T\fP]] (Linear, log, and power scaling)
.br
.TP
.B \-R
\fIxmin\fP, \fIxmax\fP, \fIymin\fP, and \fIymax\fP specify the Region of interest.  For geographic
regions, these limits correspond to \fIwest, east, south,\fP and \fInorth\fP and you may specify them
in decimal degrees or in [+-]dd:mm[:ss.xxx][W|E|S|N] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.  The two shorthands \fB\-Rg\fP and \fB\-Rd\fP stand for global domain
(0/360 or -180/+180 in longitude respectively, with -90/+90 in latitude).
For calendar time coordinates you may either give relative
time (relative to the selected \fBTIME_EPOCH\fP and in the selected \fBTIME_UNIT\fP; append \fBt\fP to
\fB\-JX\fP|\fBx\fP), or absolute time of the form [\fIdate\fP]\fBT\fP[\fIclock\fP]
(append \fBT\fP to \fB\-JX\fP|\fBx\fP).  At least one of \fIdate\fP and \fIclock\fP
must be present; the \fBT\fP is always required.  The \fIdate\fP string must be of the form [-]yyyy[-mm[-dd]]
(Gregorian calendar) or yyyy[-Www[-d]] (ISO week calendar), while the \fIclock\fP string must be of
the form hh:mm:ss[.xxx].  The use of delimiters and their type and positions must be as indicated
(however, input/output and plotting formats are flexible). 
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-C
Sets the clearance between the legend frame and the internal items [0.15\fBc\fP/0.15\fBc\fP (or 0.05\fBi\fP/0.05\fBi\fP)].
.TP
.B \-F
Draws a border around the legend using \fBFRAME_PEN\fP.
.TP
.B \-G
Specify the grey shade (0\-255) or color (r/g/b, each in range 0\-255; h-s-v, ranges
0\-360, 0\-1, 0\-1; or c/m/y/k, each in range 0\-100%; or valid color name).
Alternatively, specify \fB\-Gp\fP\fIdpi/pattern\fP, where \fIpattern\fP gives
the number of the built-in pattern (1-90) \fIor\fP the name of a Sun 1-, 8-,
or 24-bit raster file. The \fIdpi\fP sets the resolution of the image. For
1-bit rasters: use \fB\-GP\fP for inverse video, or append
\fB:F\fP\fIcolor\fP[\fBB\fP[\fIcolor\fP]] to specify fore- and background
colors (use \fIcolor\fP = - for transparency).
See \fBGMT\fP Cookbook & Technical Reference Appendix E for information
on individual patterns.
.TP
.B \-K
More \fIPostScript\fP code will be appended later [Default terminates the plot system].
.TP
.B \-L
Sets the linespacing factor in units of the current annotation font size [1.1].
.TP
.B \-O
Selects Overlay plot mode [Default initializes a new plot system].
.TP
.B \-P
Selects Portrait plotting mode [\fBGMT\fP Default is Landscape, see \fBgmtdefaults\fP to change this].
.TP
.B \-S
Instead of writing the \fIPostScript\fP plot [Default], output the \fBGMT\fP script used to make the legend
to standard output, or optionally to the file \fIscript\fP.
.TP
.B \-U
Draw Unix System time stamp on plot.  User may specify where the lower left corner
of the stamp should fall on the page relative to lower left corner of plot.  Optionally,
append a label, or \fBc\fP (which will plot the command string.).  The \fBGMT\fP parameters
\fBUNIX_TIME\fP and \fBUNIX_TIME_POS\fP can affect the appearance; see the \fBgmtdefaults\fP man
page for details.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-X \-Y
Shift plot origin relative to the current origin by (\fIx-shift,y-shift\fP) and
optionally append the length unit (\fBc\fP, \fBi\fP, \fBm\fP, \fBp\fP).
You can prepend \fBa\fP to shift the origin back to the original position after plotting,
or prepend  \fBr\fP [Default] to reset the current origin to the new location.
If \fB\-O\fP is used then the default (\fIx-shift,y-shift\fP) is (0,0), otherwise it is
(r1i, r1i) or (r2.5c, r2.5c).
Alternatively, give \fBc\fP to align the center coordinate (x or y) of the plot with the center of the page
based on current page size.
.TP
.B \-c
Specifies the number of plot copies. [Default is 1].
.SH EXAMPLES
To add an example of a legend to a Mercator plot (map.ps) with the given specifications, use
.br
.sp
\fBpslegend\fP \fB\-R\fP-10/10/-10/10 \fB\-JM\fP4i \fB\-G\fP255 \-D0/0/4i/3i/BL << EOF >> map.ps
.br
\# Legend test for pslegend
.br
\# G is vertical gap, V is vertical line, N sets # of columns, D draws horizontal line.
.br
\# H is header, L is label, S is symbol, > & T is paragraph text
.br
\#
.br
G -0.15i
.br
H 24 Times-Roman My Map Legend
.br
G 0.05i
.br
D 0.2i 1p
.br
N 2
.br
V 0 1p
.br
S 0.1i c 0.15i p300/12 0.25p 0.3i This circle is hachured
.br
S 0.1i t 0.15i yellow 0.25p 0.3i This triangle is yellow
.br
S 0.1i h 0.15i green 0.25p 0.3i This hexagon is green
.br
S 0.1i d 0.15i blue 0.25p 0.3i This diamond is blue
.br
S 0.1i - 0.15i - 0.25tap 0.3i A contour
.br
V 0 1p
.br
D 0.2i 1p
.br
N 1
.br
I SOEST_logo.ras 3 CT
.br
L 9 4 R Smith et al., @%5%J. Geophys. Res., 99@%%, 2000
.br
G 0.5i
.br
>
.br
T Let us just try some simple text that can go on a few lines.
.br
T There is no easy way to predetermine how many lines will be required,
.br
T so we may need to adjust the box height to get the right size.
.br
G -0.3i
.br
M 5 5 1000:km:l f
.br
EOF
.br
.SH WINDOWS REMARKS
Note that under Windows, the percent sign (%) is a variable indicator (like $ under Unix).
To indicate a plain percentage sign in a batch script you need to repeat it (%%);
hence the font switching mechanism (@%\fIfont\fP% and @%%) may require twice the
number of percent signs.  This only applies to text inside a script or that otherwise
is processed by DOS.  Data files that are opened and read by \fBpslegend\fP do not need such duplication.
.SH "SEE ALSO"
.IR GMT (l),
.IR psbasemap (l),
.IR pstext (l),
.IR psxy (l)
