.TH PSXYZ l "1 Apr 2007" "GMT4.2.0" "GMT4.2.0"
.SH NAME
psxyz \- Plot lines, polygons, and symbols in 3-D
.SH SYNOPSIS
\fBpsxyz\fB \fIfiles\fP \fB\-J\fP\fIparameters\fP \fB\-Jz\fP|\fBZ\fP\fIparameters\fP \fB\-R\fP\fIwest\fP/\fIeast\fP/\fIsouth\fP/\fInorth\fP[/\fIzmin\fP/\fIzmax\fP][\fBr\fP] 
[ \fB\-B\fP[\fBp\fP|\fBs\fP]\fIparameters\fP ] [ \fB\-C\fP\fIcptfile\fP ] [ \fB\-E\fP\fIazimuth\fP/\fIelevation\fP ] 
[ \fB\-G\fP\fIfill\fP ] [ \fB\-H\fP[\fBi\fP][\fInrec\fP] ] [ \fB\-K\fP ] [ \fB\-L\fP ] [ \fB\-M\fP[\fIflag\fP] ] 
[ \fB\-N\fP ] [ \fB\-O\fP ] [ \fB\-P\fP ] [ \fB\-Q\fP ] [ \fB\-S\fP[\fIsymbol\fP][\fIsize\fP] ] [ \fB\-U\fP[/\fIdx\fP/\fIdy\fP/][\fIlabel\fP] ] 
[ \fB\-V\fP ] [ \fB\-W\fP[\fIpen\fP] ] [ \fB\-X\fP[\fBa\fP|\fBc\fP|\fBr\fP][\fIx-shift\fP[\fBu\fP]] ] [ \fB\-Y\fP[\fBa\fP|\fBc\fP|\fBr\fP][\fIy-shift\fP[\fBu\fP]] ] [ \fB\-Z\fP\fIzlevel\fP ] [ \fB\-:\fP[\fBi\fP|\fBo\fP] ] [ \fB\-c\fP\fIcopies\fP ] 
[ \fB\-bi\fP[\fBs\fP|\fBS\fP|\fBd\fP|\fBD\fP][\fIncol\fP] ] [ \fB\-f\fP\fIcolinfo\fP ]
.SH DESCRIPTION
\fBpsxyz\fP reads (x,y,z) triplets from \fIfiles\fP [or standard input] and
generates \fIPostScript\fP code that will plot lines, polygons, or symbols at those locations in 3-D.
If a symbol is selected and no symbol size given, then psxyz will interpret the fourth column of the
input data as symbol size.  Symbols whose size is <= 0 are skipped.  If no symbols are specified then the symbol code (see \fB\-S\fP below)
must be present as last column in the input.  Multiple segment files may be plotted using the \fB\-M\fP option.
If no symbols are selected, a line will be drawn.  To explicitly close polygons, use \fB\-L\fP.  Select a shade with \fB\-G\fP.  If \fB\-G\fP is set, \fB\-W\fP
will control whether the polygon outline is drawn or not.  If a symbol is selected, \fB\-G\fP and
\fB\-W\fP determines the fill color and outline/no outline, respectively.
The \fIPostScript\fP code is written to standard output. 
.TP
\fIfiles\fP
List one or more file-names. If no files are given, \fBpsxyz\fP will read standard input.
.TP
.B \-J
Selects the map projection. Scale is UNIT/degree, 1:xxxxx, or width in UNIT (upper case modifier).
UNIT is cm, inch, or m, depending on the \fBMEASURE_UNIT\fP setting in \.gmtdefaults4, but this can be
overridden on the command line by appending \fBc\fP, \fBi\fP, or \fBm\fP to the scale/width value.
For map height, max dimension, or min dimension, append \fBh\fP, \fB+\fP, or \fB-\fP to the width,
respectively.
.br
More details can be found in the \fBpsbasemap\fP man pages.
.br
.sp
\fBCYLINDRICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jc\fP\fIlon0/lat0/scale\fP (Cassini)
.br
\fB\-Jj\fP\fIlon0/scale\fP (Miller)
.br
\fB\-Jm\fP\fIscale\fP (Mercator - Greenwich and Equator as origin)
.br
\fB\-Jm\fP\fIlon0/lat0/scale\fP (Mercator - Give meridian and standard parallel)
.br
\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP (Oblique Mercator - point and azimuth)
.br
\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP (Oblique Mercator - two points)
.br
\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP (Oblique Mercator - point and pole)
.br
\fB\-Jq\fP\fIlon0/scale\fP (Equidistant Cylindrical Projection (Plate Carree))
.br
\fB\-Jt\fP\fIlon0/scale\fP (TM - Transverse Mercator, with Equator as y = 0)
.br
\fB\-Jt\fP\fIlon0/lat0/scale\fP (TM - Transverse Mercator, set origin)
.br
\fB\-Ju\fP\fIzone/scale\fP (UTM - Universal Transverse Mercator)
.br
\fB\-Jy\fP\fIlon0/lats/scale\fP (Basic Cylindrical Projection) 
.br
.sp
\fBAZIMUTHAL PROJECTIONS:\fP
.br
.sp
\fB\-Ja\fP\fIlon0/lat0/scale\fP (Lambert)
.br
\fB\-Je\fP\fIlon0/lat0/scale\fP (Equidistant)
.br
\fB\-Jf\fP\fIlon0/lat0/horizon/scale\fP (Gnomonic)
.br
\fB\-Jg\fP\fIlon0/lat0/scale\fP (Orthographic)
.br
\fB\-Js\fP\fIlon0/lat0/\fP[\fIslat/\fP]\fIscale\fP (General Stereographic)
.br
.sp
\fBCONIC PROJECTIONS:\fP
.br
.sp
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP (Albers)
.br
\fB\-Jd\fP\fIlon0/lat0/lat1/lat2/scale\fP (Equidistant)
.br
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP (Lambert)
.br
.sp
\fBMISCELLANEOUS PROJECTIONS:\fP
.br
.sp
\fB\-Jh\fP\fIlon0/scale\fP (Hammer)
.br
\fB\-Ji\fP\fIlon0/scale\fP (Sinusoidal)
.br
\fB\-Jk\fP[\fBf|s\fP]\fIlon0/scale\fP (Eckert IV (f) and VI (s))
.br
\fB\-Jn\fP\fIlon0/scale\fP (Robinson)
.br
\fB\-Jr\fP\fIlon0/scale\fP (Winkel Tripel)
.br
\fB\-Jv\fP\fIlon0/scale\fP (Van der Grinten)
.br
\fB\-Jw\fP\fIlon0/scale\fP (Mollweide)
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jp\fP[\fBa\fP]\fIscale\fP[\fI/origin\fP][\fBr\fP|\fBz\fP] (Polar coordinates (theta,r))
.br
\fB\-Jx\fP\fIx-scale\fP[\fBd|l|p\fP\fIpow\fP\fB|t|T\fP][\fI/y-scale\fP[\fBd|l|p\fP\fIpow\fP\fB|t|T\fP]] (Linear, log, and power scaling)
.br
.TP
.B \-Jz
Sets the vertical scaling (for 3-D maps).  Same syntax as \fB\-Jx\fP.
.TP
.B \-R
\fIxmin\fP, \fIxmax\fP, \fIymin\fP, and \fIymax\fP specify the Region of interest.  For geographic
regions, these limits correspond to \fIwest, east, south,\fP and \fInorth\fP and you may specify them
in decimal degrees or in [+-]dd:mm[:ss.xxx][W|E|S|N] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.  The two shorthands \fB\-Rg\fP and \fB\-Rd\fP stand for global domain
(0/360 or -180/+180 in longitude respectively, with -90/+90 in latitude).
For calendar time coordinates you may either give relative
time (relative to the selected \fBTIME_EPOCH\fP and in the selected \fBTIME_UNIT\fP; append \fBt\fP to
\fB\-JX\fP|\fBx\fP), or absolute time of the form [\fIdate\fP]\fBT\fP[\fIclock\fP]
(append \fBT\fP to \fB\-JX\fP|\fBx\fP).  At least one of \fIdate\fP and \fIclock\fP
must be present; the \fBT\fP is always required.  The \fIdate\fP string must be of the form [-]yyyy[-mm[-dd]]
(Gregorian calendar) or yyyy[-Www[-d]] (ISO week calendar), while the \fIclock\fP string must be of
the form hh:mm:ss[.xxx].  The use of delimiters and their type and positions must be as indicated
(however, input/output and plotting formats are flexible). 
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-B
Sets map boundary annotation and tickmark intervals; see the
\fBpsbasemap\fP man page for all the details.
.TP
.B \-C
Give a color palette file.  If \fB\-S\fP is set, let symbol fill color be determined by the t-value in
the fourth column.  Additional
fields are shifted over by one column (optional size would be in 5th rather than
4th field, etc.).
If \fB\-S\fP is not set, then psxyz expects a multisegment line or polygon file (requires \fB\-M\fP)
where each segment header contains a \fB\-Z\fP\fIval\fP string.  The \fIval\fP
will control the color of the line or polygon (use \fB\-L\fP) via the cpt file.
.TP
.B \-E
Sets the viewpoint's azimuth and elevation [180/90].\"'
.TP
.B \-G
Select color for filling of symbols or select color or pattern for filling of polygons [Default is no fill].
.br
Specify the grey shade (0\-255) or color (r/g/b, each in range 0\-255; h-s-v, ranges
0\-360, 0\-1, 0\-1; or c/m/y/k, each in range 0\-100%; or valid color name).
Alternatively, specify \fB\-Gp\fP\fIdpi/pattern\fP, where \fIpattern\fP gives
the number of the built-in pattern (1-90) \fIor\fP the name of a Sun 1-, 8-,
or 24-bit raster file. The \fIdpi\fP sets the resolution of the image. For
1-bit rasters: use \fB\-GP\fP for inverse video, or append
\fB:F\fP\fIcolor\fP[\fBB\fP[\fIcolor\fP]] to specify fore- and background
colors (use \fIcolor\fP = - for transparency).
See \fBGMT\fP Cookbook & Technical Reference Appendix E for information
on individual patterns.
.br
Note when \fB\-M\fP is chosen, \fBpsxyz\fP will search for \fB\-G\fP and \fB\-W\fP
strings in all the subheaders and let any found values over-ride the command line settings.
The following special settings are also supported: \fB\-G\-\fP turns fill off and \fB\-G+\fP resets
fill to the command line setting (or none if command line \fB\-G\fP not set); likewise \fB\-W\-\fP turns outlines off
and \fB\-W+\fP resets outline to the command line setting (or none if \command line \fB\-W\fP not set).
Also see \fB\-C\fP for color look-up via \fB\-Z\fP strings in the subheaders.
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults4 file.  If used, \fBGMT\fP default is 1 header record. Use \fB\-Hi\fP
if only input data should have header records [Default will write out header records if the
input data have them].
.TP
.B \-K
More \fIPostScript\fP code will be appended later [Default terminates the plot system].
.TP
.B \-L
Force closed polygons: will connect the endpoints of the line-segment(s) and draw polygons.
.TP
.B \-M
Multiple segment file.  Segments are separated by a record whose first character is \fIflag\fP.
[Default is '>'].
.TP 
.B \-N 
Do NOT skip symbols that fall outside map border [Default plots points inside border only]. 
.TP
.B \-O
Selects Overlay plot mode [Default initializes a new plot system].
.TP
.B \-P
Selects Portrait plotting mode [\fBGMT\fP Default is Landscape, see \fBgmtdefaults\fP to change this].
.TP
.B \-Q
Turn off the automatic sorting of items based on their distance from the viewer.  The default is
to sort the items so that items in the foreground are plotted after items in the background.
.TP
.B \-S
Plot symbols.  \fIsize\fP is symbol size in the unit set in \.gmtdefaults4
(unless \fBc\fP, \fBi\fP, \fBm\fP, or \fBp\fP is appended).   If the symbol
code (see below) is not given it will be read from the last column in the input data;
this cannot be used in conjunction with \fB\-b\fP.  Optionally, append
c, i, m, p to indicate that the size information in the
input data is in units of cm, inch, meter, or point,
respectively. [Default is \fBMEASURE_UNIT\fP].
The uppercase symbols
\fBA, C, D, G, H, I, N, S, T\fP are normalized to have the same area as a circle of given size,
while the corresponding lowercase symbols are circumscribed by the circle.
Choose between:
.TP
.B \-S-
x-dash.  \fIsize\fP is the length of a short horizontal (x-dir) line segment.
.TP
.B \-Sa
st\fBa\fPr.  \fIsize\fP is diameter of circumscribing circle.
.TP
.B \-Sb
Vertical (\fBb\fP)ar extending from \fIbase\fP to y.  \fIsize\fP is bar width.  Append \fBu\fP
if \fIsize\fP is in x-units [Default is plot-distance units]. By default,
\fIbase\fP = ymin.  Append b\fIbase\fP to change this value.  
.TP
.B \-SB
Horizontal (\fBb\fP)ar extending from \fIbase\fP to x.  \fIsize\fP is bar width.  Append \fBu\fP
if \fIsize\fP is in y-units [Default is plot-distance units]. By default,
\fIbase\fP = xmin.  Append b\fIbase\fP to change this value.  
.TP
.B \-Sc
(\fBc\fP)ircle.  \fIsize\fP is diameter of circle.
.TP
.B \-Sd
(\fBd\fP)iamond.  \fIsize\fP is diameter of circumscribing circle.
.TP
.B \-Se
\fBe\fPllipse.  Direction (in degrees counterclockwise from horizontal), major_axis, and minor_axis must be found in columns 4, 5, and 6.
.TP
.B \-SE
Same as \fB\-Se\fP, except azimuth (in degrees east of north) should be given instead of direction.  The azimuth will
be mapped into an angle based on the chosen map projection (\fB\-Se\fP leaves the directions
unchanged.)  Furthermore, the axes lengths must be given in km instead of plot-distance units.  An exception occurs for
a linear projection if which we assume the ellipse axes are given in the same units as \fB\-R\fP.
.TP
.B \-Sf
\fBf\fPront.  \fB\-Sf\fP\fIgap/size\fP[\fIdir\fP][\fItype\fP][:\fIoffset\fP].  Supply distance gap between symbols and symbol size.
If \fIgap\fP is negative, it is interpreted to mean the number of symbols along the front instead.  Append \fIdir\fP to plot symbols
on the \fBl\fPeft or \fBr\fPight side of the front [Default is centered].  Append \fItype\fP to specify which symbol
to plot: \fBb\fPox, \fBc\fPircle, \fBf\fPault, \fBs\fPlip, or \fBt\fPriangle.  [Default is fault].
Slip means left-lateral or right-lateral strike-slip arrows (centered is not an option).  Append :\fIoffset\fP to offset
the first symbol from the beginning of the front by that amount [0].
.TP
.B \-Sg
octa\fBg\fPon.  \fIsize\fP is diameter of circumscribing circle.
.TP
.B \-Sh
\fBh\fPexagon.  \fIsize\fP is diameter of circumscribing circle.
.TP
.B \-Si
\fBi\fPnverted triangle.  \fIsize\fP is diameter of circumscribing circle.
.TP
.B \-Sj
Rotated rectangle.  Direction (in degrees counter-clockwise from horizontal), x-dimension, and y-dimension must be found in columns 4, 5, and 6.
.TP
.B \-SJ
Same as \fB\-Sj\fP, except azimuth (in degrees east of north) should be given instead of direction.  The azimuth will
be mapped into an angle based on the chosen map projection (\fB\-Sj\fP leaves the directions
unchanged.)  Furthermore, the dimensions must be given in km instead of plot-distance units.  An exception occurs for
a linear projection in which we assume the dimensions are given in the same units as \fB\-R\fP.
.TP
.B \-Sk
\fBk\fPustom symbol.  Append <name>/\fIsize\fP, and we will look for a definition file called
<name>.def in (1) the current directory or (2) in ~/.gmt or (3) in \fB$GMT_SHAREDIR\fP/custom.  The symbol as defined
in that file is of size 1.0 by default; the appended \fIsize\fP will scale symbol accordingly.
The symbols are plotted in the \fIx-y\fP plane.
Users may add their own custom *.def files; see CUSTOM SYMBOLS in the \fBpsxy\fP man page.
.TP
.B \-Sl
\fBl\fPetter or text string (less than 64 characters).  Give size, and append /\fIstring\fP after the size.  Note that the size is only approximate; no individual scaling
is done for different characters.  Remember to escape special characters like *.  Optionally, you may append %\fIfont\fP
to select a particular font [Default is \fBANNOT_FONT_PRIMARY\fP].
.TP
.B \-Sn
pe\fBn\fPtagon.  \fIsize\fP is diameter of circumscribing circle.
.TP
.B \-So
c(\fBo\fP)lumn (3-D) extending from \fIbase\fP to z.  \fIsize\fP sets base width (Use \fIxsize/ysize\fP if not the same).  Append \fBu\fP if \fIsize\fP is in x-units
[Default is plot-distance units].  By default, \fIbase\fP = 0.  Append b\fIbase\fP to change this value.  The facet colors will be modified to simulate shading.
Use \fB\-SO\fP to disable such 3-D illumination.
.TP
.B \-Sp
(\fBp\fP)oint.  No size needs to be specified.
.TP
.B \-Sq
\fBq\fPuoted line, i.e., lines with annotations such as contours.  It is assumed that each individual line has a
constant \fIz\fP level (i.e., each line must lie in the \fIx-y\fP plane).  Append [\fBd|f|n|l|x\fP]\fIinfo\fP[:\fIlabelinfo\fP].
The required argument controls the placement of labels along the quoted lines.
Choose among five controlling algorithms:
.RS
.TP
\fBd\fP\fIdist\fP[c|i|m|p] or \fBD\fP\fIdist\fP[d|e|k|m|n]
For lower case \fBd\fP, give distances between labels on the plot in your preferred measurement unit
\fBc\fP (cm), \fBi\fP (inch), \fBm\fP (meter), or \fBp\fP (points), while for upper case \fBD\fP, specify
distances in map units and append the unit; choose among \fBe\fP (m), \fBk\fP (km), \fBm\fP (mile), \fBn\fP
(nautical mile), or \fBd\fP (spherical degree).  [Default is 10\fBc\fP or 4\fBi\fP].  
.TP
\fBf\fP\fIffile.d\fP
Reads the ascii file \fIffile.d\fP and places labels at locations in the file
that matches locations along the quoted lines.
Inexact mathces and points outside the region are skipped.
.TP
\fBl|L\fP\fIline1\fP[,\fIline2\fP,...]
Give \fIstart\fP and \fIstop\fP coordinates for one or
more comma-separated straight line segments.  Labels will be placed where these lines intersect the
quoted lines.  The format of each \fIline\fP specification is \fIstart/stop\fP, where \fIstart\fP and \fIstop\fP
are either a specified point \fIlon/lat\fP or a 2-character \fBXY\fP key that uses the justification
format employed in \fBpstext\fP to indicate a point on the map, given as [LCR][BMT].
\fBL\fP will interpret the point pairs as defining great circles [Default is straight line].
.TP
\fBn\fP\fIn_label\fP
Specifies the number of equidistant labels for quoted lines line [1].
Upper case \fBN\fP starts labeling exactly at the start of the line [Default centers them along the line].
\fBN\fP-1 places one justified label at start, while \fBN\fP+1 places one justified
label at the end of quoted lines.
Optionally, append /\fImin_dist\fP[c|i|m|p] to enforce that a minimum distance separation
between successive labels is enforced.
.TP
\fBx|X\fP\fIxfile.d\fP
Reads the multi-segment file \fIxfile.d\fP and places labels at the intersections
between the quoted lines and the lines in\fIxfile.d\fP.  \fBX\fP will resample the lines first along
great-circle arcs.
.RE
In addition, you may optionally append :\fIradius\fP[c|i|m|p] to set a minimum label separation in the
x-y plane [no limitation].
.sp
.RS
The optional \fIlabelinfo\fP controls the specifics of the label formatting and consists of a concatenated string
made up of any of the following control arguments:
.RE
.RS
.TP
\fB+a\fP\fIangle\fP
For annotations at a fixed angle, \fB+an\fP for line-normal, or \fB+ap\fP for line-parallel [Default].
.TP
\fB+c\fP\fIdx\fP[/\fIdy\fP]
Sets the clearance between label and optional text box.  Append \fBc|i|m|p\fP to specify
the unit or % to indicate a percentage of the label font size [15%].
.TP
\fB+f\fP\fIfont\fP
Sets the desired font [Default \fBANNOT_FONT_PRIMARY\fP].
.TP
\fB+g\fP[\fIcolor\fP]
Selects opaque text boxes [Default is transparent]; optionally specify the color [Default is \fBPAGE_COLOR\fP].
.TP
\fB+j\fP\fIjust\fP
Sets label justification [Default is CM].
.TP
\fB+k\fP\fIcolor\fP
Sets color of text labels [Default is \fBCOLOR_BACKGROUND\fP].
.TP
\fB+l\fP\fIlabel\fP
Sets the constant label text.
.TP
\fB+L\fP\fIflag\fP
Sets the label text according to the specified flag:
.RS
.TP
\fB+Lh\fP
Take the label from the current multisegment header (first scan for an embedded
\fB\-L\fP\fIlabel\fP option, if not use the first word following the segment flag).
.TP
\fB+Ld\fP
Take the Cartesian plot distances along the line as the label; append \fBc|i|m|p\fP
as the unit [Default is \fBMEASURE_UNIT\fP].
.TP
\fB+LD\fP
Calculate actual map distances; append \fBd|e|k|m|n\fP as the unit [Default is \fBd\fP(egrees),
unless label placement was based on map distances along the lines in which case we use the same unit specified for that algorithm].
Requires a map projection to be used.
.TP
\fB+Lf\fP
Use text after the 2nd column in the fixed label location file as the label.  Requires the fixed label
location setting.
.TP
\fB+Lx\fP
As \fB+Lh\fP but use the headers in the \fIxfile.d\fP instead.  Requires the crossing file option.
.RE
.TP
\fB+o\fP
Selects rounded rectangular text box [Default is rectangular].  Not applicable for curved text (\fB+v\fP) and
only makes sense for opaque text boxes.
.TP
\fB+p\fP[\fIpen\fP]
Draws the outline of text boxsets [Default is no outline]; optionally specify pen for outline [Default is width = 0.25p, color = black, texture = solid].
\fIpen\fP is a comma delimetered list of \fIwidth\fP, \fIcolor\fP and \fItexture\fP, each of which is optional.
\fIwidth\fP can be indicated as a measure (points, centimeters, inches) or as \fBfaint\fP, \fBthin\fP[\fBner\fP|\fBnest\fP],
\fBthick\fP[\fBer\fP|\fBest\fP], \fBfat\fP[\fBter\fP|\fBtest\fP], or \fBobese\fP.
\fIcolor\fP specifies a grey shade (0\-255) or color (r/g/b, each in range 0\-255; h-s-v, ranges
0\-360, 0\-1, 0\-1; or c/m/y/k, each in range 0\-100%; or valid color name).
\fItexture\fP is a combination of dashes `-' and dots `.'.
.TP
\fB+r\fP\fImin_rad\fP
Will not place labels where the line's radius of curvature is less than \fImin_rad\fP [Default is 0].\"'
.TP
\fB+s\fP\fIsize\fP
Sets the desired font size in points [Default is 9].
.TP
\fB+u\fP\fIunit\fP
Appends \fIunit\fP to all line labels. If \fIunit\fP starts with a leading hypen (-) then there will be no space
between label value and the unit.
[Default is no unit].
.TP
\fB+v\fP
Specifies curved labels following the path [Default is straight labels].
.TP
\fB+w\fP
Specifies how many (\fIx, y\fP) points will be used to estimate label angles [Default is 10].
.TP
\fB+=\fP\fIprefix\fP
Prepends \fIprefix\fP to all line labels.
If \fIprefix\fP starts with a leading hypen (-) then there will be no space
between label value and the prefix. [Default is no prefix].
.RE
.TP
.B \-Sr
\fBr\fPectangle.  No size needs to be specified, but the x- and y-dimensions must be found in columns 4 and 5.
.TP
.B \-Ss
(\fBs\fP)quare.  \fIsize\fP is diameter of circumscribing circle.
.TP
.B \-St
(\fBt\fP)riangle.  \fIsize\fP is diameter of circumscribing circle.
.TP
.B \-Su
c(\fBu\fP)be (3-D).  \fIsize\fP sets length of all sides. Append \fBu\fP if \fIsize\fP
is in x-units [Default is plot-distance units].  The facet colors will be modified to simulate shading.
Use \fB\-SU\fP to disable such 3-D illumination.
.TP
.B \-Sv
(\fBv\fP)ector.  Direction and length must be found in columns 4 and 5.
\fIsize\fP means \fIarrowwidth/headlength/headwidth\fP in [[Default is 0.075\fBc\fP/0.3\fBc\fP/0.25\fBc\fP (or 0.03\fBi\fP/0.12\fBi\fP/0.1\fBi\fP)].
By default arrow attributes remains invariant to the length
of the arrow.  To have the size of the vector scale down with decreasing size,
append \fBn\fP\fInorm\fP, where vectors shorter than \fInorm\fP will have their
attributes scaled by length/\fInorm\fP.  To center vector on balance point, use \fB\-Svb\fP; to align point with the vector head,
use \fB\-Svh\fP; to align point with the vector tail, use \fB\-Svt\fP [Default]. To give the head point's \fIx, y, z\fP coordinates\"'
instead of direction and length, use \fB\-Svs\fP.  Upper case \fBB, H, T, S\fP will draw a double-headed vector [Default is single head].
.TP
.B \-SV
Same as \fB\-Sv\fP, except azimuth should be given instead of direction.  The azimuth will
be mapped into an angle based on the chosen map projection (\fB\-Sv\fP leaves the directions
unchanged.)
.TP
.B \-Sw
pie \fBw\fPedge.  Start and stop directions (in degrees counter-clockwise from horizontal) for pie slice
must be found in columns 4 and 5.
.TP
.B \-SW
Same as \fB\-Sw\fP, except azimuths (in degrees east of north) should be given instead of the two directions.  The azimuths will
be mapped into angles based on the chosen map projection (\fB\-Sw\fP leaves the directions unchanged.)
.TP
.B \-Sx
(\fBx\fP)cross. \fIsize\fP is diameter of circumscribing circle.
.br
.TP
.B \-Sy
y-dash.  \fIsize\fP is the length of a short horizontal (y-dir) line segment.
.TP
.B \-Sz
zdash.  \fIsize\fP is the length of a short vertical (z-dir) line segment.
.TP
.B \-U
Draw Unix System time stamp on plot.  User may specify where the lower left corner
of the stamp should fall on the page relative to lower left corner of plot.  Optionally,
append a label, or \fBc\fP (which will plot the command string.).  The \fBGMT\fP parameters
\fBUNIX_TIME\fP and \fBUNIX_TIME_POS\fP can affect the appearance; see the \fBgmtdefaults\fP man
page for details.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-W
Set pen attributes for lines or the outline of symbols.  [Defaults: width = 1, color = black, texture = solid].
\fIpen\fP is a comma delimetered list of \fIwidth\fP, \fIcolor\fP and \fItexture\fP, each of which is optional.
\fIwidth\fP can be indicated as a measure (points, centimeters, inches) or as \fBfaint\fP, \fBthin\fP[\fBner\fP|\fBnest\fP],
\fBthick\fP[\fBer\fP|\fBest\fP], \fBfat\fP[\fBter\fP|\fBtest\fP], or \fBobese\fP.
\fIcolor\fP specifies a grey shade (0\-255) or color (r/g/b, each in range 0\-255; h-s-v, ranges
0\-360, 0\-1, 0\-1; or c/m/y/k, each in range 0\-100%; or valid color name).
\fItexture\fP is a combination of dashes `-' and dots `.'.
.TP
.B \-X \-Y
Shift plot origin relative to the current origin by (\fIx-shift,y-shift\fP) and
optionally append the length unit (\fBc\fP, \fBi\fP, \fBm\fP, \fBp\fP).
You can prepend \fBa\fP to shift the origin back to the original position after plotting,
or prepend  \fBr\fP [Default] to reset the current origin to the new location.
If \fB\-O\fP is used then the default (\fIx-shift,y-shift\fP) is (0,0), otherwise it is
(r1i, r1i) or (r2.5c, r2.5c).
Alternatively, give \fBc\fP to align the center coordinate (x or y) of the plot with the center of the page
based on current page size.
.TP
.B \-Z
For 3-D projections:  Sets the z-level of the basemap [0].
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input and/or output.  [Default is (longitude,latitude)].
Append \fBi\fP to select input only or \fBo\fP to select output only.  [Default affects both].
.TP
.B \-bi
Selects binary input.  Append \fBs\fP for single precision [Default is \fBd\fP (double)].
Uppercase \fBS\fP (or \fBD\fP) will force byte-swapping.
Optionally, append \fIncol\fP, the number of columns in your binary file
if it exceeds the columns needed by the program.
[Default is the required number of columns given the settings].
.TP
.B \-c
Specifies the number of plot copies. [Default is 1].
.TP
.B \-f
Special formatting of input and output columns (time or geographical data).
Specify \fBi\fP(nput) or \fBo\fP(utput) [Default is both input and output].
Give one or more columns (or column ranges) separated by commas.
Append \fBT\fP (Absolute calendar time), \fBt\fP (time relative to chosen \fBTIME_EPOCH\fP),
\fBx\fP (longitude), \fBy\fP (latitude), or \fBf\fP (floating point) to each column
or column range item.  Shorthand \fB\-f\fP[\fBi\fP|\fBo\fP]\fBg\fP means \fB\-f\fP[\fBi\fP|\fBo\fP]0\fBx\fP,1\fBy\fP
(geographic coordinates).
.SH EXAMPLES
To plot blue columns (width = 1.25 cm) at the positions listed in the file heights.xyz on a
3-D projection of the space (0\-10), (0\-10), (0\-100),  with tickmarks every 2, 2, and 10,
viewing it from the southeast at 30 degree elevation, use:
.br
.sp
\fBpsxyz\fP heights.xyz \fB\-R\fP0/10/0/10/0/100 \fB\-Jx\fP1.25\fBc \-Jz\fP0.125\fBc \-So\fP1.25\fBc\fP
\fB\-G\fPblue \fB\-B\fP2:XLABEL:/2:YLABEL:/10:ZLABEL::."3-D PLOT":15 \fB\-E\fP135/30 \fB\-Uc
\-W\fP \fB\-P\fP > heights.ps
.SH BUGS
No hidden line removal is employed for polygons and lines.  Symbols, however, are first sorted
according to their distance from the viewpoint so that nearby symbols will overprint more distant
ones should they project to the same x,y position.
.br
\fBpsxyz\fP cannot handle filling of polygons that contain the south or north pole.  For such a polygon,
make a copy and split it into two and make each explicitly contain the polar point.  The two polygons
will combine to give the desired effect when filled; to draw outline use the original polygon.
.br
The \fB\-N\fP option does not adjust the BoundingBox information so you may
have to post-process the PostScript outout with epstool or ps2epsi to obtain
a correct BoundingBox.
.SH "SEE ALSO"
.IR GMT (l),
.IR psbasemap (l),
.IR psxy (l)
