.TH SURFACE l "1 Apr 2007" "GMT4.2.0" "GMT4.2.0"
.SH NAME
surface \- adjustable tension continuous curvature surface gridding algorithm
.SH SYNOPSIS
\fBsurface\fP [ \fIxyzfile\fP ] \fB\-G\fP\fIoutputfile.grd\fP \fB\-I\fP\fIxinc\fP[\fIunit\fP][\fB=\fP|\fB+\fP][/\fIyinc\fP[\fIunit\fP][\fB=\fP|\fB+\fP]] \fB\-R\fP\fIwest\fP/\fIeast\fP/\fIsouth\fP/\fInorth\fP[\fBr\fP] [ \fB\-A\fP\fIaspect_ratio\fP ] 
[ \fB\-C\fP\fIconvergence_limit\fP ] [ \fB\-H\fP[\fBi\fP][\fInrec\fP] ] [ \fB\-Ll\fP\fIlower\fP ] [ \fB\-Lu\fP\fIupper\fP ] [ \fB\-N\fP\fImax_iterations\fP ] [ \fB\-Q\fP ] 
[ \fB\-S\fP\fIsearch_radius\fP[\fBm\fP] ] [ \fB\-T\fP\fItension_factor\fP[\fBi\fP|\fBb\fP] ] [ \fB\-V\fP[\fBl\fP] ] 
[ \fB\-Z\fP\fIover-relaxation_factor\fP ] [ \fB\-:\fP[\fBi\fP|\fBo\fP] ] [ \fB\-bi\fP[\fBs\fP|\fBS\fP|\fBd\fP|\fBD\fP][\fIncol\fP] ] [ \fB\-f\fP\fIcolinfo\fP ]
.SH DESCRIPTION
\fBsurface\fP reads randomly-spaced (x,y,z) triples from standard input [or \fIxyzfile\fP] and produces
a binary grdfile of gridded values z(x,y) by solving:
.sp
	(1 - T) * L (L (z)) + T * L (z) = 0
.sp
where T is a tension factor between 0 and 1, and L indicates the Laplacian operator.
T = 0 gives the "minimum curvature" solution which is equivalent to SuperMISP and the ISM
packages.  Minimum curvature can cause undesired oscillations and false local maxima or minima
(See Smith and Wessel, 1990), and you may wish to use T > 0 to suppress these effects.
Experience suggests T ~ 0.25 usually looks good for potential field data and T should be larger
(T ~ 0.35) for steep topography data.  T = 1 gives a harmonic surface (no maxima or minima are
possible except at control data points).  It is recommended that the user pre-process the data with
\fBblockmean\fP, \fBblockmedian\fP, or \fBblockmode\fP to avoid spatial aliasing and eliminate redundant data.
You may impose lower and/or upper bounds on the solution.  These may be entered in the form of
a fixed value, a grdfile with values, or simply be the minimum/maximum input data values.
.TP
\fIxyzfile\fP
3 column ASCII file [or binary, see \fB\-b\fP] holding (x,y,z) data values.  If no file is specified, \fBsurface\fP will read from
standard input.
.TP
.B \-G
Output file name.  Output is a binary 2-D \fI.grd\fP file.
.TP
.B \-I
\fIx_inc\fP [and optionally \fIy_inc\fP] is the grid spacing. Append \fBm\fP to
indicate minutes or \fBc\fP to indicate seconds.  If one of the units \fBe\fP, \fBk\fP, \fBi\fP,
or \fBn\fP is appended instead, the increment will be assumed to be in meter, km, miles, or
nautical miles, respectively, and will be converted to the equivalent degrees longitude at
the middle latitude of the region (the conversion depends on \fBELLIPSOID\fP).  If /\fIy_inc\fP is given but set to 0 it will be reset equal to
\fIx_inc\fP; otherwise it will be converted to degrees latitude.  If \fB=\fP is appended then
the corresponding max \fIx\fP (\fIeast\fP) or \fIy\fP (\fInorth\fP) may be slightly adjusted to fit exactly the given increment
[by default the increment may be adjusted slightly to fit the given domain].  Finally, instead
of giving an increment you may specify the \fInumber of nodes\fP desired by appending \fB+\fP to
the supplied increment; the increment is then recalculated from the number of nodes and the domain.
The resulting increment value depends on whether you have selected a gridline-registered or pixel-
registered grid; see Appendix B for details.
.TP
.B \-R
\fIxmin\fP, \fIxmax\fP, \fIymin\fP, and \fIymax\fP specify the Region of interest.  For geographic
regions, these limits correspond to \fIwest, east, south,\fP and \fInorth\fP and you may specify them
in decimal degrees or in [+-]dd:mm[:ss.xxx][W|E|S|N] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.  The two shorthands \fB\-Rg\fP and \fB\-Rd\fP stand for global domain
(0/360 or -180/+180 in longitude respectively, with -90/+90 in latitude).
For calendar time coordinates you may either give relative
time (relative to the selected \fBTIME_EPOCH\fP and in the selected \fBTIME_UNIT\fP; append \fBt\fP to
\fB\-JX\fP|\fBx\fP), or absolute time of the form [\fIdate\fP]\fBT\fP[\fIclock\fP]
(append \fBT\fP to \fB\-JX\fP|\fBx\fP).  At least one of \fIdate\fP and \fIclock\fP
must be present; the \fBT\fP is always required.  The \fIdate\fP string must be of the form [-]yyyy[-mm[-dd]]
(Gregorian calendar) or yyyy[-Www[-d]] (ISO week calendar), while the \fIclock\fP string must be of
the form hh:mm:ss[.xxx].  The use of delimiters and their type and positions must be as indicated
(however, input/output and plotting formats are flexible). 
.SH OPTIONS
.sp
.TP
.B \-A
Aspect ratio.  If desired, grid anisotropy can be added to the equations.  Enter \fIaspect_ratio\fP,
where dy = dx / \fIaspect_ratio\fP relates the grid dimensions.  [Default = 1 assumes isotropic grid.]
.TP
.B \-C
Convergence limit.  Iteration is assumed to have converged when the maximum absolute change in 
any grid value is less than \fIconvergence_limit\fP.  (Units same as data z units).  [Default is scaled
to 0.1 percent of typical gradient in input data.]
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults4 file.  If used, \fBGMT\fP default is 1 header record. Use \fB\-Hi\fP
if only input data should have header records [Default will write out header records if the
input data have them].
Not used with binary data.
.TP
.B \-L
Impose limits on the output solution.  \fBl\fP\fIlower\fP sets the lower bound.  \fIlower\fP can be the name of a
grdfile with lower bound values, a fixed value, \fBd\fP to set to minimum input value, or \fBu\fP for unconstrained [Default].
\fBu\fP\fIupper\fP sets the upper bound and can be the name of a
grdfile with upper bound values, a fixed value, \fBd\fP to set to maximum input value, or \fBu\fP for unconstrained [Default].
.TP
.B \-N
Number of iterations.  Iteration will cease when \fIconvergence_limit\fP is reached or when number of
iterations reaches \fImax_iterations\fP. [Default is 250.]
.TP
.B \-Q
Suggest grid dimensions which have a highly composite greatest
common factor. This allows surface to use several intermediate steps in the
solution, yielding faster run times and better results. The sizes suggested by
\fB\-Q\fP can be achieved by altering \fB\-R\fP and/or \fB\-I\fP. You can
recover the \fB\-R\fP and \fB\-I\fP you want later by using \fBgrdsample\fP or \fBgrdcut\fP on the output of \fBsurface\fP.
.TP
.B \-S
Search radius.  Enter \fIsearch_radius\fP in same units as x,y data; append \fBm\fP to indicate minutes.
This is used to initialize the grid before the first iteration; it is not worth the time unless the
grid lattice is prime and cannot have regional stages.  [Default = 0.0 and no search is made.]
.TP
.B \-T
Tension factor[s].  These must be between 0 and 1.  Tension may be used in the interior solution
(above equation, where it suppresses spurious oscillations) and in the boundary conditions (where
it tends to flatten the solution approaching the edges).  Using zero for both values results in
a minimum curvature surface with free edges, i.e. a natural bicubic spline.
Use \fB\-T\fP\fItension_factor\fP\fBi\fP to set interior tension, and \fB\-T\fP\fItension_factor\fP\fBb\fP
to set boundary tension.  If you do not append \fBi\fP or \fBb\fP, both will be set to the same value.
[Default = 0 for both gives minimum curvature solution.]
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
\fB\-Vl\fP will report the convergence after each iteration;  \fB\-V\fP will report only after 
each regional grid is converged.
.TP
.B \-Z
Over-relaxation factor.  This parameter is used to accelerate the convergence; it is a number between
1 and 2.  A value of 1 iterates the equations exactly, and will always assure stable convergence.  Larger
values overestimate the incremental changes during convergence, and will reach a solution more rapidly but may
become unstable.  If you use a large value for this factor, it is a good idea to monitor each iteration
with the \fB\-Vl\fP option.  [Default = 1.4 converges quickly and is almost always stable.]
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input and/or output.  [Default is (longitude,latitude)].
Append \fBi\fP to select input only or \fBo\fP to select output only.  [Default affects both].
.TP
.B \-bi
Selects binary input.  Append \fBs\fP for single precision [Default is \fBd\fP (double)].
Uppercase \fBS\fP (or \fBD\fP) will force byte-swapping.
Optionally, append \fIncol\fP, the number of columns in your binary file
if it exceeds the columns needed by the program.
[Default is 3 input columns].
.TP
.B \-f
Special formatting of input and output columns (time or geographical data).
Specify \fBi\fP(nput) or \fBo\fP(utput) [Default is both input and output].
Give one or more columns (or column ranges) separated by commas.
Append \fBT\fP (Absolute calendar time), \fBt\fP (time relative to chosen \fBTIME_EPOCH\fP),
\fBx\fP (longitude), \fBy\fP (latitude), or \fBf\fP (floating point) to each column
or column range item.  Shorthand \fB\-f\fP[\fBi\fP|\fBo\fP]\fBg\fP means \fB\-f\fP[\fBi\fP|\fBo\fP]0\fBx\fP,1\fBy\fP
(geographic coordinates).
.SH GRID VALUES PRECISION
Regardless of the precision of the input data, GMT programs that create
gridded files will internally hold the grids in 4-byte floating point
arrays.  This is done to conserve memory and futhermore most if not all
real data can be stored using 4-byte floating point values.  Data with
higher precision (i.e., double precision values) will loose that precision
once GMT operates on the grid or writes out new grids.  To limit loss
of precision when processing data you should always consider normalizing
the data prior to processing.
.SH EXAMPLES
.sp
To grid 5 by 5 minute gravity block means from the ASCII data in hawaii_5x5.xyg, using a \fItension_factor\fP = 0.25,
a \fIconvergence_limit\fP = 0.1 milligal, writing the result to a file called hawaii_grd.grd, 
and monitoring each iteration, try:
.sp
\fBsurface\fP hawaii_5x5.xyg \fB\-R\fP198/208/18/25 \fB\-I\fP5\fBm\fP \fB\-G\fPhawaii_grd.grd \fB\-T\fP0.25 \fB\-C\fP0.1 \fB\-Vl\fP
.SH BUGS
\fBsurface\fP will complain when more than one data point is found for
any node and suggest that you run \fBblockmean\fP, \fBblockmedian\fP, or \fBblockmode\fP first.  If you
did run \fBblockm*\fP and still get this message it usually means that your
grid spacing is so small that you need more decimals in the output format used by
\fBblockm*\fP.  You may specify more decimal places by editing the
parameter \fBD_FORMAT\fP in your \.gmtdefaults4 file prior to running \fBblockm*\fP,
or choose binary input and/or output using single or double precision storage.
.SH "SEE ALSO"
.IR blockmean (l),
.IR blockmedian (l),
.IR blockmode (l),
.IR GMT (l),
.IR nearneighbor (l),
.IR triangulate (l)
.SH REFERENCES
Smith, W. H. F, and P. Wessel, 1990, Gridding with continuous curvature splines in tension, \fIGeophysics\fP,
55, 293\-305.
