# Copyright (C) 2005-2007 Quentin Sculo <squentin@free.fr>
#
# This file is part of Gmusicbrowser.
# Gmusicbrowser is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 3, as
# published by the Free Software Foundation

use strict;
use warnings;

package GMBDBusObject;

use base qw(Net::DBus::Object);
use Net::DBus::Exporter qw(org.gmusicbrowser.SimpleInterface);

sub new
{	my ($class,$service) = @_;
	my $self = $class->SUPER::new($service, '/GMBDBusObject');
	bless $self, $class;

	Glib::Idle->add(
		sub {	::Watch($self,SongID => \&SongChanged);
			::Watch($self,Playing =>\&SongChanged);
			#::Watch($self,Save => \&GMB::DBus::Quit);
			0;
		});

	return $self;
}

dbus_method('RunCommand', ['string'], []);
sub RunCommand
{   my ($self,$cmd) = @_;
    warn "Received DBus command : '$cmd'\n";
    ::run_command(undef,$cmd);
}

dbus_method('CurrentSong', [], [['dict', 'string', 'string']]);
sub CurrentSong
{	my $self=$_[0];
	return {} unless defined $::SongID;
	my %h=	(	title	=> ::SONG_TITLE,
			album	=> ::SONG_ALBUM,
			artist	=> ::SONG_ARTIST,
			'length'=> ::SONG_LENGTH,
			track	=> ::SONG_TRACK,
			disc	=> ::SONG_DISC,
		);
	$_=$::Songs[$::SongID][$_] for values %h;
	#warn "$h{title}\n";
	return \%h;
}

dbus_method('GetPosition', [], ['double']);
sub GetPosition
{	my $self=$_[0];
	return $::PlayTime || 0;
}

dbus_method('Set', [['struct', 'string', 'string', 'string']], ['bool']);
sub Set
{	my ($self,$array)=@_;
	::SetTagValue(@$array); #return false on error, true if ok
}
dbus_method('Get', [['struct', 'string', 'string']], ['string']);
sub Get
{	my ($self,$array)=@_;
	::GetTagValue(@$array);
}
dbus_method('GetLibrary', [], [['array', 'uint32']]);
sub GetLibrary
{	\@::Library;
}

dbus_method('GetAlbumCover', ['string'], ['string']);
sub GetAlbumCover
{	my ($self,$album)=@_;
	my $ref=$::Album{$album};
	return undef unless $ref && $ref->[::AAPIXLIST];
	return $ref->[::AAPIXLIST];
}
dbus_method('GetAlbumCoverData', ['string'], [['array', 'byte']]);
sub GetAlbumCoverData
{	my ($self,$album)=@_;
	my $ref=$::Album{$album};
	return undef unless $ref && $ref->[::AAPIXLIST];
	my $file=$ref->[::AAPIXLIST];
	return undef unless -r $file;
	my $data;
	if ($file=~m/\.mp3/i)
	{	$data=ReadTag::PixFromMP3($file);
	}
	else
	{	open my$fh,'<',$file; binmode $fh;
		read $fh,$data, (stat $file)[7];
		close $fh;
	}
	return [map ord,split //, $data];
}

dbus_signal('SongChanged', ['uint32']);
my $lasttime;
sub SongChanged
{	my $self=$_[0];
	return unless defined $::SongID && $::TogPlay;
	return if $lasttime && $::StartTime==$lasttime; #if song hasn't really changed
	$lasttime=$::StartTime;
	$self->emit_signal(SongChanged => $::SongID);
}

package GMB::DBus;

use Net::DBus;
use Net::DBus::Service;
use Net::DBus::Reactor;

Glib::Idle->add(\&init); #initialize once the main gmb init is finished

sub init
{	my $bus = Net::DBus->find;
	my $service = $bus->export_service('org.gmusicbrowser');
	my $object = GMBDBusObject->new($service);

	my $reactor=Net::DBus::Reactor->main;
	# use Net::DBus internals to connect it to the Glib mainloop, though unlikely, it may break with future version of Net::DBus
	for my $ref (['in','read'],['out','write'], ['err','exception'])
	{	my ($type1,$type2)=@$ref;
		for my $fd (keys %{$reactor->{fds}{$type2}})
		{	#warn "$fd $type2";
			Glib::IO->add_watch($fd,$type1,
			sub{	$reactor->{fds}{$type2}{$fd}{callback}->invoke;
				$_->invoke for $reactor->_dispatch_hook;
				1;
			   }) if $reactor->{fds}{$type2}{$fd}{enabled};
			#Glib::IO->add_watch($fd,$type1,sub { Net::DBus::Reactor->main->step;Net::DBus::Reactor->main->step;1; }) if $reactor->{fds}{$type2}{$fd}{enabled};
		}
	}

	0; #called in an idle, return 0 to run only once
}

1;
