/**
 * GMyth Library
 * 
 * @file gmyth/gmyth_recprofile.h
 * 
 * @brief <p> This file contains the recprofile class.
 *
 * Copyright (C) 2007 INdT - Instituto Nokia de Tecnologia.
 * @author Artur Duque de Souza <artur.souza@indt.org.br>
 *
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _GMYTH_RECPROFILE_H
#define _GMYTH_RECPROFILE_H

#include <glib.h>
#include <glib-object.h>

#include "gmyth_stringlist.h"
#include "gmyth_backendinfo.h"
#include "gmyth_socket.h"

G_BEGIN_DECLS
#define GMYTH_RECPROFILE_TYPE               (gmyth_recprofile_get_type ())
#define GMYTH_RECPROFILE(obj)               (G_TYPE_CHECK_INSTANCE_CAST ((obj), GMYTH_RECPROFILE_TYPE, GMythRecProfile))
#define GMYTH_RECPROFILE_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), GMYTH_RECPROFILE_TYPE, GMythRecProfileClass))
#define IS_GMYTH_RECPROFILE(obj)            (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GMYTH_RECPROFILE_TYPE))
#define IS_GMYTH_RECPROFILE_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GMYTH_RECPROFILE_TYPE))
#define GMYTH_RECPROFILE_GET_CLASS(obj)     (G_TYPE_INSTANCE_GET_CLASS ((obj), GMYTH_RECPROFILE_TYPE, GMythRecProfileClass))
typedef struct _Options Options;
typedef struct _GMythRecProfile GMythRecProfile;
typedef struct _GMythRecProfileClass GMythRecProfileClass;

struct _GMythRecProfileClass {
    GObjectClass    parent_class;
    gint            teste;
    /*
     * callbacks 
     */
};

struct _GMythRecProfile {
    gint            id;
    gchar          *name;
    gchar          *group;
    gchar          *vcodec;
    gchar          *acodec;
    Options        *options;
};

struct _Options {
    gint            transcodelossless;
    gint            transcoderesize;
    gint            width;
    gint            height;
    gint            rtjpegquality;
    gint            rtjpeglumafilter;
    gint            rtjpegchromafilter;
    gint            mpeg4bitrate;
    gint            mpeg4maxquality;
    gint            mpeg4minquality;
    gint            mpeg4qualdiff;
    gint            mpeg4scalebitrate;
    gint            mpeg4optionvhq;
    gint            mpeg4option4mv;
    gint            mpeg4optionidct;
    gint            mpeg4optionime;
    gint            hardwaremjpegquality;
    gint            hardwaremjpeghdecimation;
    gint            hardwaremjpegvdecimation;
    gchar          *mpeg2streamtype;
    gchar          *mpeg2aspectratio;
    gint            mpeg2bitrate;
    gint            mpeg2maxbitrate;
    gint            samplerate;
    gint            mp3quality;
    gint            volume;
    gchar          *mpeg2audtype;
    gint            mpeg2audbitratel1;
    gint            mpeg2audbitratel2;
    gint            mpeg2audvolume;
};

GType           gmyth_recprofile_type(void);

GMythRecProfile *gmyth_recprofile_new(void);

GSList         *gmyth_recprofile_get_profile_list(GMythBackendInfo *
                                                  backend_info);

gint            gmyth_recprofile_create_profile(GMythBackendInfo *
                                                backend_info,
                                                GMythRecProfile * profile);

gint            gmyth_recprofile_del_profile_list(GMythBackendInfo *
                                                  backend_info, gint id);

gint            gmyth_recprofile_set_acodec(GMythRecProfile * rec,
                                            gchar * acodec);
gint            gmyth_recprofile_set_vcodec(GMythRecProfile * rec,
                                            gchar * vcodec);
gint            gmyth_recprofile_set_group(GMythRecProfile * rec,
                                           gchar * group);
gint            gmyth_recprofile_set_name(GMythRecProfile * rec,
                                          gchar * name);
gint            gmyth_recprofile_set_id(GMythRecProfile * rec, gint id);

G_END_DECLS
#endif /*_GMYTH_RECPROFILE_H*/
