/**
 * GMyth Library
 *
 * @file gmyth/gmyth_vlc.h
 * 
 * @brief <p> GMythVLC library provides functions that
 * interact with a VLC server running telnet interface.
 *
 * Copyright (C) 2007 INdT - Instituto Nokia de Tecnologia.
 * @author Artur Duque de Souza <artur.souza@indt.org.br>
 *
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __GMYTH_VLC_H__
#define __GMYTH_VLC_H__

#include <glib-object.h>

#include <glib.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>
#include <netdb.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <sys/socket.h>


#include "gmyth_backendinfo.h"
#include "gmyth_util.h"

G_BEGIN_DECLS
#define VLC_TELNET_PORT 4212
#define BUFFER 512
#define MPEG1 0
#define THEORA 1
typedef struct _GMythVlc GMythVlc;

struct _GMythVlc {
    int             sockfd;

    // Number of outputs used
    int             n_outputs;

    // Number of inputs
    int             n_inputs;

    // Socket vars
    struct hostent *he;
    struct sockaddr_in their_addr;

    char            buf[BUFFER];
};



int             gmyth_vlc_setup_output(GMythVlc * vlc, int output,
                                       gchar * kind, gchar * opts);


int             gmyth_vlc_clean_playlist(GMythVlc * vlc);


int             gmyth_vlc_control_input(GMythVlc * vlc, int output,
                                        gchar * command);

int             gmyth_vlc_create_input(GMythVlc * vlc, int output,
                                       gchar * file);

int             gmyth_vlc_create_channel(GMythVlc * vlc, gchar * type,
                                         int port, int vcodec);

int             gmyth_vlc_connect(GMythVlc * vlc,
                                  GMythBackendInfo * backend_info,
                                  gchar * passwd, int port);

int             gmyth_vlc_disconnect(GMythVlc * vlc);

G_END_DECLS
#endif                          /* __GMYTH_VLC_H__ */
