------------------------------------------------------------------------------
--  Thin Ada95 binding to OCI (Oracle Call Interface)                    --
--  Copyright (C) 2000-2004 Dmitriy Anisimkov.                              --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $Id: oci-thick-notifications.ads,v 1.4 2004/06/28 04:57:05 vagul Exp $

with OCI.Thick.Connections;
with System;

package OCI.Thick.Notifications is

   use OCI.Thick.Connections;

   type Subscription is tagged limited private;

   Already_Registered : exception;

   type Namespace_Enum is (AQ, Anonymous);

   type Buffer_Type is private;

   procedure Enable (Item : in Subscription);

   procedure Disable (Item : in Subscription);

   procedure Create
     (Item      : in out Subscription;
      Name      : in     String;
      Namespace : in     Namespace_Enum);

   procedure Post
     (Item    : in out Subscription;
      Connect : in     Connection;
      Data    : in     String);

   procedure Register
     (Item    : in out Subscription;
      Connect : in     Connection);

   procedure Unregister (Item : in out Subscription);

   procedure Notify
     (Item   : in out Subscription;
      Buffer : in     Buffer_Type);

   function To_String (Buffer : in Buffer_Type) return String;

private

   type Subscription is new AF.Limited_Controlled with record
      Handle : aliased OCISubscription := OCISubscription (Empty_Handle);
      Connect : Connection;
   end record;

   type Buffer_Type is record
      Ptr      : System.Address := System.Null_Address;
      Length   : Natural := 0;
   end record;

   procedure Finalize (Object : in out Subscription);

end OCI.Thick.Notifications;
