------------------------------------------------------------------------------
--  Ada95 Interface to Oracle RDBMS                                         --
--  Copyright (C) 2000-2004 Dmitriy Anisimkov.                              --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $Id: oci-thick-number_functions.adb,v 1.7 2004/06/28 04:57:05 vagul Exp $

with OCI.Environments;
with OCI.Thread;

with System;

package body OCI.Thick.Number_Functions is

   -------------------
   -- To_Long_Float --
   -------------------

   function To_Long_Float (Numb : OCINumber) return Long_Float is
      use type UWord;
      Result : aliased Long_Float;
      Rc : SWord := OCINumberToReal
                      (Thread.Error,
                       Numb,
                       Result'Size / System.Storage_Unit,
                       Result'Access);
   begin
      Check_Error (Rc);
      return Result;
   end To_Long_Float;

   ---------------
   -- To_Number --
   ---------------

   function To_Number (From : Long_Float) return OCINumber is
      use type UWord;
      Numb   : aliased Long_Float := From;
      Result : aliased OCINumber;
      Rc     : SWord := OCINumberFromReal
                     (Thread.Error,
                      Numb'Access,
                      Numb'Size / System.Storage_Unit,
                      Result'Access);
   begin
      Check_Error (Rc);
      return Result;
   end To_Number;

   function To_Number (From : String; Format : String) return OCINumber is
      Result : aliased OCINumber;
      Rc : SWord := OCINumberFromText
        (Err          => Thread.Error,
         Buf          => C.To_C (From),
         Str_Length   => From'Length,
         Fmt          => C.To_C (Format),
         Fmt_Length   => Format'Length,
         NLS_params   => Empty,
         nls_p_length => 0,
         number       => Result'Access);
   begin
      Check_Error (Rc);
      return Result;
   end To_Number;

   ---------------
   -- To_String --
   ---------------

   function To_String (From : OCINumber; Format : String) return String is
      use type Ub4;
      Buff : aliased Text := (0 .. 63 => C.nul);
      Len  : aliased Ub4 := Buff'Length;
      Rc   : SWord := OCINumberToText
        (Err        => Thread.Error,
         Date       => From,
         Fmt        => C.To_C (Format),
         Fmt_Length => Format'Length,
         Nls_Name   => Empty,
         Nls_Length => 0,
         Buf_Size   => Len'Access,
         Buf        => CStr.To_Chars_Ptr (Buff'Unchecked_Access));
   begin
      Check_Error (Rc);
      return C.To_Ada (Buff (0 .. C.size_t (Len - 1)), False);
   end To_String;

begin
   OCI.Environments.Set_Create_Mode_Flag (OCI_OBJECT);
end OCI.Thick.Number_Functions;
