------------------------------------------------------------------------------
--  Thin Ada95 binding to OCI (Oracle Call Interface)                    --
--  Copyright (C) 2000-2004 Dmitriy Anisimkov.                              --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $Id: oci-thread.ads,v 1.7 2004/06/28 04:57:05 vagul Exp $

with
   Ada.Finalization,
   Ada.Task_Attributes,

   OCI.Lib,
   OCI.Environments;

use
   OCI.Environments,
   OCI.Lib;

private package OCI.Thread is

   function Error return OCIError;

   function Environment return OCIEnv;

   protected Synch is

      function Environment return Thread_Environment;
      --  Returun Environment of current task
      --  every task has the same environment by default.

      function Task_Dedicated_Environment return Boolean;
      --  Creates environment for current task only
      --  Should be called before first call to the library
      --  in this thread or never.

   end Synch;

   procedure Set_Error (Env : OCIEnv; Err : OCIError);
   --  for initalize from Extproc Context

   type Error_Type is new Ada.Finalization.Controlled with record
      Handle       : OCIError := OCIError (Empty_Handle);
      Environment  : Thread_Environment;
   end record;

   procedure Finalize (Object : in out Error_Type);

   Init_Error : constant Error_Type :=
       (Ada.Finalization.Controlled with
            Handle       => OCIError (Empty_Handle),
            Environment  => Init_Environment);

   package Attributes is new
      Ada.Task_Attributes (Error_Type, Init_Error);

end OCI.Thread;
