------------------------------------------------------------------------------
--  Thin Ada95 binding to OCI (Oracle Call Interface)                    --
--  Copyright (C) 2000-2004 Dmitriy Anisimkov.                              --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  Anonymous Publish-Subscribe Example.
--  Working only with Oracle 8.1.7 and later.

--  $Id: subscr.adb,v 1.6 2004/06/28 04:57:06 vagul Exp $

with Ada.Text_IO;
with Ada.Command_Line;

with Subscriber;

with OCI.Thick.Connections;
with OCI.Thick.Notifications;

procedure Subscr is

   use OCI.Thick.Connections;
   use Subscriber;
   use Ada.Text_IO;

   Connect : Connection;
   Consumer : Subscriber_Type;

begin
   Put_Line ("=========");

   if Ada.Command_Line.Argument_Count = 1 then
      Connect := Logon (Ada.Command_Line.Argument (1));
   else
      Connect := Logon ("scott/tiger");
   end if;

   Create (Consumer,
           "test_subscr_notification",
           OCI.Thick.Notifications.Anonymous);

   Register (Consumer, Connect);

   Enable (Consumer);

   loop
      declare
         Line : String (1 .. 80);
         Last : Natural;
      begin
         Put ('>');
         Get_Line (Line, Last);
         exit when Line (1 .. Last) = "exit";
         Post (Consumer, Connect, Line (1 .. Last));
      end;

   end loop;

   Unregister (Consumer);
end Subscr;
