-------------------------------------------------------------------------------
--
--  Filename        : $Source: /cvsroot/gnade/gnade/tools/sql.adb,v $
--  Description     : Execute an sql command                                 --
--  Author          : Michael Erdmann                                        --
--  Created         : 5.4.2003                                               --
--  Last Modified By: $Author: merdmann $
--  Last Modified On: $Date: 2004/03/20 08:30:21 $
--  Status          : $State: Exp $
--
--  Copyright (C) 2000 - 2003 Michael Erdmann                                --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  Author: Michael Erdmann <michael.erdmann@snafu.de>                       --
--                                                                           --
--  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
--                                                                           --
--  Functional Description                                                   --
--  ======================                                                   --
--                                                                           --
--  This programm allows to explore an odbc interface                        --
--       								     --
--                                                                           --
--  Restrictions                                                             --
--  ============                                                             --
--  None                                                                     --
--                                                                           --
--  References                                                               --
--  ==========                                                               --
--  None                                                                     --
--                                                                           --
-------------------------------------------------------------------------------
with Ada.Text_IO;		use Ada.Text_IO;
with Ada.Command_Line;          use Ada.Command_Line;
with Ada.Strings.Unbounded;     use Ada.Strings.Unbounded;
with ODBC;      		use ODBC;
with Tools;                     use Tools;

procedure SQL is
   Version : constant String := "$Id: sql.adb,v 1.8 2004/03/20 08:30:21 merdmann Exp $";

   Q       : Unbounded_String := Null_Unbounded_String;
   DB      : ODBC.Object;
   Login   : Unbounded_String;
   Pwd     : Unbounded_String;
   Source  : Unbounded_String;
   Argc    : Natural := 1;
   Quiet   : Boolean := False;

   Error, Message : Unbounded_String;
   QFile   : Unbounded_String := Null_Unbounded_String;
   ----------
   -- Help --
   ----------
   procedure Help is
   begin
      Put_Line("usage : " );
      Put_Line("    sql -u <login> [ -p <passwd> ]  <source> [<query> | -f <file> " );
      Put_Line("");
   end Help;

   ------------
   -- Header --
   ------------
   procedure Print_Header(
      R : in Result_Record ) is
      -- Display the column name of a given result set
   begin
      if Quiet then
         return;
      end if;

      for I in R'Range loop
         Put( Field_Name(DB, I) & " " );
      end loop;
      Put_Line("");
   end Print_Header;

   ---------
   -- Row --
   ---------
   procedure Print_Row(
      R : in Result_Record )  is
   begin
      for I in R'Range loop
         Put( To_String( R(I) ) & ";" );
      end loop;
      Put_Line("");
   end Print_Row;


   -------------
   -- Execute --
   -------------
   procedure Execute(
      Q : in Unbounded_String ) is
      R : Result_Record := null;
   begin
      Query( DB, To_String(Q) );
      R := Fetch( DB );

      Print_Header(R);

      while R /= null loop
         Print_Row( R );
	 Free( R );
	 R := Fetch( DB );
      end loop;

   exception
         when others =>
            Get_Error( DB, Error, Message );
	    Put_Line( To_String( Error ) & ":" & To_String( Message ) );
	    Set_Exit_Status( Failure );
   end;


begin
   Initialize(DB);

   -- Handle the command line arguments
   while Argc in 1..Argument_Count loop
      declare
         Arg : constant String := Argument( Argc );
      begin
         if Arg = "-u" then
            Argc := Argc + 1;
            Login := To_Unbounded_String( Argument( Argc ) );
         elsif Arg = "-p" then
            Argc := Argc + 1;
            Pwd := To_Unbounded_String( Argument( Argc ) );
         elsif Arg = "-h" then
	    Help;
	    return;
	 elsif Arg = "-q" then
            Quiet := True;
         elsif Arg = "-f" then
            Argc := Argc + 1;
            QFile := To_Unbounded_String( Argument( Argc ) );
	 else
	    if Source = Null_Unbounded_String then
	    	Source := To_Unbounded_String( Arg );
	    else
	        Q:= Q & To_Unbounded_String( Arg & " " );
	    end if;
	 end if;
         Argc := Argc + 1;
      end;
   end loop;

   if not Quiet then
      Put_Line("GNADE SQL Executor, Version " & Tools.Version);
      Put_Line("Copyright (C) 2003, Michael Erdmann (michael.erdmann@snafu.de)");
      Put_Line("");
   end if;

   if Source = Null_Unbounded_String then
      Put_Line("source not specified");
      Put_Line("");
      Help;
      Set_Exit_Status(Failure);
      return;
   end if;

   -- connect to the data base
   begin
      Authorization( DB, To_String(Login), To_String(Pwd) );
      Data_Source( DB, To_String(Source) );
      Connect( DB );
   exception
      when others =>
      	 Get_Error( DB, Error, Message );
         Put_Line( "Could not connect to " & To_String( Source ) &
                  "Reason: " & To_String( Error ) & ", " &
                  To_String( Message )
         );
         Set_Exit_Status( Failure );
         return;
   end ;

   -- if a query is available execute it make the result visible
   if QFile /= Null_Unbounded_String then
      declare
         F      : File_Type ;
         Line   : String( 1..255 );
         Length : Integer := 0;
      begin
         Open( File => F, Name => To_String(QFile), Mode => In_File );
         while not End_Of_File( F ) loop
            Get_Line( F, Line, Length );
            if Line(1) /= ';' and Line(1) /= '#' then
               Q := Q & To_Unbounded_String( Line( 1..Length ) & " " );
            end if;
         end loop;

         Close(F);
      end ;
   end if;

   Execute(Q);

   --Finalize( DB );
   Set_Exit_Status( Success );

exception
   when Others =>
      Get_Error( DB, Error, Message );
      Put_Line( To_String( Error ) & ":" & To_String( Message ) );
      Set_Exit_Status( Failure );
end SQL;
