-------------------------------------------------------------------------------
--
--  Filename        : $Source: /cvsroot/gnade/gnade/contrib/gsql/gui_tools.adb,v $
--  Description     : Handle the toolbar of a client
--  Author          : Michael Erdmann
--  Created         : 8.8.2001
--  Last Modified By: $Author: merdmann $
--  Last Modified On: $Date: 2002/06/09 09:46:38 $
--  Status          : $State: Exp $
--
--  Copyright (C) 2000 Michael Erdmann
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  Author: Michael Erdmann <michael.erdmann@snafu.de>                       --
--                                                                           --
--  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
--                                                                           --
-------------------------------------------------------------------------------

with Ada.Strings.Unbounded;    use Ada.Strings.Unbounded;
with Ada.Text_Io;              use Ada.Text_IO;
with Ada.Exceptions;           use Ada.Exceptions;
with Ada.Strings;              use Ada.Strings;
with Ada.Strings.Fixed;        use Ada.Strings.Fixed;

-- GTK Support packages (gtkada package)

with Glib;                     use Glib;

with Gdk;
with Gdk.Drawable;             use Gdk.Drawable;
with Gdk.Bitmap;               use Gdk.Bitmap;
with Gdk.Event;                use Gdk.Event;
with Gdk.Font;                 use Gdk.Font;
with Gdk.Color;                use Gdk.Color;
with Gdk.GC;                   use Gdk.GC;
with Gdk.Pixmap;               use Gdk.Pixmap;
with Gdk.Rectangle;            use Gdk.Rectangle;
with Gdk.Types;                use Gdk.Types;
with Gdk.Window;               use Gdk.Window;

with Gtk.Rc;
with Gtk;                      use Gtk;
with Gtk.Arguments;            use Gtk.Arguments;
with Gtk.Box;                  use Gtk.Box;
with Gtk.Button;               use Gtk.Button;
with Gtk.Enums;                use Gtk.Enums;
with Gtk.Frame;                use Gtk.Frame;
with Gtk.Handlers;             use Gtk.Handlers;
with Gtk.Label;                use Gtk.Label;
with Gtk.Notebook;             use Gtk.Notebook;

with Gtk.Pixmap;               use Gtk.Pixmap;
with Gtkada.Handlers;          use Gtkada.Handlers;

with Gtk.Style;                use Gtk.Style;
with Gtk.Text;                 use Gtk.Text;
with Gtk.Window;               use Gtk.Window;
with Gtk.Widget;               use Gtk.Widget;
with Gtk.Toolbar;              use Gtk.Toolbar;

-- GSQL Support packages

with ODBC;                     use ODBC;
with GSQL_Types;               use GSQL_Types;

with Gui_Files;                use GUI_Files;
with GUI_Result;               use GUI_Result;
with GUI_Editor;               use GUI_Editor;
with GUI_Preferences;          use GUI_Preferences;
with GUI_Logging;              use GUI_Logging;
with GUI_Menu;                 use GUI_Menu;
with GUI_Worksheet;            use GUI_Worksheet;

with Contents_Manager.GUI;     use Contents_Manager.GUI;
with Contents_Handler;         use Contents_Handler;
with Query_Handler;            use Query_Handler;
with Table_Handler;            use Table_Handler;
with Procedure_Handler;        use Procedure_Handler;
with Datasource_Handler;       use Datasource_Handler;
with Files;                    use Files;

package body GUI_Tools is

   Version : constant String :=
      "$Id: gui_tools.adb,v 1.11 2002/06/09 09:46:38 merdmann Exp $";

   --- *********************************************************************** --
   --- ***                L O C A L   D A T A    TYPES                     *** --
   --- *********************************************************************** --

   -----------------
   -- GTK Objects --
   -----------------
   Toolbar        : Gtk_Toolbar;
   Tb_Frame       : Gtk_Frame;

   Class_Name     : Unbounded_String := Null_Unbounded_String;

   --- *********************************************************************** --
   --- ***                L O C A L    P R O C E D U  R E S                *** --
   --- *********************************************************************** --

   ----------------------
   -- Support Packages --
   ----------------------
   package Destroyed is new Gtk.Handlers.Callback (
      Widget_Type => Gtk_Window_Record);

   package Toolbar_Cb is new
      Handlers.Callback (Gtk_Toolbar_Record);

   ----------------
   -- New_Pixmap --
   ----------------
   function New_Pixmap (
      Filename   : in String ) return Gtk_Widget is
      -- place a new pixmap in the tool bar frame.
      Pixmap     : Gdk_Pixmap;
      Mask       : Gdk_Bitmap;
      GtkPixmap  : Gtk_Pixmap;
      Window     : constant Gdk_Window := Get_Window(Tb_Frame);
      Background : constant Gdk_Color  := Get_Bg(Get_Style(Tb_Frame), State_Normal);
   begin
      Create_From_Xpm (Pixmap, Window, Mask, Background, Shared_File(Filename));
      Gtk_New (GtkPixmap, Pixmap, Mask);
      return Gtk_Widget (GtkPixmap);
   end New_Pixmap;

   ----------------------------
   -- Handle_Toolbar_Execute --
   ----------------------------
   procedure Handle_Toolbar_Execute(
      Toolbar : access Gtk_Toolbar_Record'Class) is
      Id      : Element_ID := GUI.Last_Selected;
   begin
      Execute( Contents( Id ).all );
   end Handle_Toolbar_Execute;

   ------------------------
   -- Handle_Toolbar_New --
   ------------------------
   procedure Handle_Toolbar_New(
      Toolbar     : access Gtk_Toolbar_Record'Class ) is
      --- create a new instance of the selected class
      Item        : Contents_Handler.Handle;
      Name        : Unbounded_String := Files.Buffer_Name;
      ---
   begin
      if Class_Name /= Null_Unbounded_String then
         Item := Contents_Manager.Create( Class_Name, Name );
         Open_Editor( Item.all );
         Set_Page( Toplevel );

         Class_Name := Null_Unbounded_String;
         GUI_Logging.Clear_Status;
      else
         Error("Please select the instance class first");
      end if;
   end Handle_Toolbar_New;

   ---------------------------
   -- Handle_Toolbar_Delete --
   ---------------------------
   procedure Handle_Toolbar_Delete(
      Toolbar     : access Gtk_Toolbar_Record'Class ) is
      -- delete the currently selected item
      Id          : Element_ID := GUI.Last_Selected;
   begin
      Finalize( Contents(Id).all );
   end Handle_Toolbar_Delete;

   -------------------------
   -- Handle_Toolbar_Save --
   -------------------------
   procedure Handle_Toolbar_Save(
      Toolbar     : access Gtk_Toolbar_Record'Class ) is
      Handler     : Contents_Handler.Handle := GUI_Worksheet.Contents;
      Data        : Text_Buffer( 1..Max_Section_Length );
      Last        : Positive := 1;
   begin
      if Handler /= null then
         Log("Saving " & Key( Handler.all ));
         Value( Handler.all, Data, Last );
         Save( Handler.all, Data( 1..Last ), Key( Handler.all)  );
      else
         Error("No Editor active");
      end if;

   end Handle_Toolbar_Save;

   --------------
   -- Add_Tool --
   --------------
--     procedure Add_Tool(
--        Name    : in String;
--        Hint    : in String;
--        Xpm     : in String;
--        Handler : in Toolbar_CB.Widget_Marshaller.Handler )  is
--     begin
--        Toolbar_Cb.Object_Connect(
--           Append_Item (
--               Toolbar,
--               Name,
--               Hint,
--               "",
--               New_Pixmap (
--                  Xpm,
--                  Get_Window(Tb_Frame),
--                  Get_Bg (Get_Style(Tb_Frame), State_Normal)
--               )
--           ),
--           "clicked",
--           Toolbar_Cb.To_Marshaller (Handler),
--           Slot_Object => Toolbar
--        );
--     end Add_Tool;

   procedure Add_Tools is
   begin
      Toolbar_Cb.Object_Connect(
         Append_Item (
             Toolbar,
             "New",
             "Create a new query",
             "",
             New_Pixmap ( "test.xpm" )),
         "clicked",
         Toolbar_Cb.To_Marshaller (Handle_Toolbar_New'Access),
         Slot_Object => Toolbar
      );
      Toolbar_Cb.Object_Connect(
         Append_Item (
             Toolbar,
             "Delete",
             "Delete an object",
             "",
             New_Pixmap ( "test.xpm" )),
         "clicked",
         Toolbar_Cb.To_Marshaller (Handle_Toolbar_Delete'Access),
         Slot_Object => Toolbar
      );

      Toolbar_Cb.Object_Connect(
         Append_Item (
             Toolbar,
             "Save",
             "Save the current query",
             "",
             New_Pixmap ("test.xpm")),
         "clicked",
         Toolbar_Cb.To_Marshaller (Handle_Toolbar_Save'Access),
         Slot_Object => Toolbar
      );

      Toolbar_Cb.Object_Connect(
         Append_Item (
             Toolbar,
             "Execute",
             "Execute a query",
             "",
             New_Pixmap ("test.xpm")),
         "clicked",
         Toolbar_Cb.To_Marshaller (Handle_Toolbar_Execute'Access),
         Slot_Object => Toolbar
      );
   end Add_Tools;

   --- *************************************************************************** --
   --- ***                     M A I N   P R O C E D U R E                     *** --
   --- *************************************************************************** --

   --------------
   -- Activate --
   --------------
   procedure Activate(
      Cls : in String ) is
   begin
      Class_Name := To_Unbounded_String(Cls);
      GUI_Logging.Set_Status( Cls );
   end Activate;

   ----------
   -- Main --
   ----------
   procedure Add_Toolbar(
      Wbox : in out Gtk_Box ) is
   begin
      Gtk_New (Tb_Frame, "");
      Gtk_New (Toolbar, Orientation_Horizontal, Toolbar_Both);
      Add_Tools;
      Set_Orientation (Toolbar, Orientation_Horizontal);
      Add( Tb_Frame, Toolbar );
      Show_All(Tb_Frame);

      Pack_Start(Wbox, Child => TB_Frame, Expand => False );
   end Add_Toolbar;

end GUI_Tools;

