------------------------------------------------------------------------------
--  Thin Ada binding to OCI (Oracle Call Interface)                     --
--  Copyright (C) 2007-2008 Dmitriy Anisimkov.                              --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $RCSfile: oci-thick-containers-enumeration.adb,v $
--  $Revision: 1.6 $ $Date: 2008/03/13 10:25:26 $ $Author: vagul $

with OCI.Thick.DB;

package body OCI.Thick.Containers.Enumeration is

   -----------
   -- Clear --
   -----------

   procedure Clear
     (Container : in out Container_Type;
      Name      : in     Enum;
      Iteration : in     Positive := 1) is
   begin
      Clear
        (Container => Container,
         Position  => Container.Index (Name),
         Iteration => Iteration);
   end Clear;

   ---------
   -- Get --
   ---------

   function Get
     (Container : in Container_Type;
      Name      : in Enum;
      Iteration : in Positive := 1) return Integer is
   begin
      return Get
               (Container => Container,
                Position  => Container.Index (Name),
                Iteration => Iteration);
   end Get;

   ---------
   -- Get --
   ---------

   function Get
     (Container : in Container_Type;
      Name      : in Enum;
      Iteration : in Positive := 1) return Long_Float is
   begin
      return Get
               (Container => Container,
                Position  => Container.Index (Name),
                Iteration => Iteration);
   end Get;

   ---------
   -- Get --
   ---------

   function Get
     (Container : in Container_Type;
      Name      : in Enum;
      Iteration : in Positive := 1) return String is
   begin
      return Get
               (Container => Container,
                Position  => Container.Index (Name),
                Iteration => Iteration);
   end Get;

   ---------
   -- Get --
   ---------

   function Get
     (Container : in Container_Type;
      Name      : in Enum;
      Iteration : in Positive := 1) return OCINumber is
   begin
      return Get
               (Container => Container,
                Position  => Container.Index (Name),
                Iteration => Iteration);
   end Get;

   ---------
   -- Get --
   ---------

   function Get
     (Container : in Container_Type;
      Name      : in Enum;
      Iteration : in Positive := 1) return Ada.Calendar.Time is
   begin
      return Get
               (Container => Container,
                Position  => Container.Index (Name),
                Iteration => Iteration);
   end Get;

   ---------
   -- Get --
   ---------

   function Get
     (Container : in Container_Type;
      Name      : in Enum;
      Iteration : in Positive := 1) return Lobs.Locator is
   begin
      return Get
               (Container => Container,
                Position  => Container.Index (Name),
                Iteration => Iteration);
   end Get;

   ---------
   -- Get --
   ---------

   function Get
     (Container : in Container_Type;
      Name      : in Enum;
      Iteration : in Positive := 1) return Data_Holder is
   begin
      return Get
               (Container => Container,
                Position  => Container.Index (Name),
                Iteration => Iteration);
   end Get;

   ---------
   -- Get --
   ---------

   procedure Get
     (Container : in     Container_Type;
      Item      :    out Data_Holder;
      Name      : in     Enum;
      Iteration : in     Positive := 1) is
   begin
      Get
        (Container => Container,
         Item      => Item,
         Position  => Container.Index (Name),
         Iteration => Iteration);
   end Get;

   -----------
   -- Index --
   -----------

   function Index
     (Container : in Container_Type; Name : in Enum) return Natural is
   begin
      return Container.Index (Name);
   end Index;

   -------------
   -- Is_Null --
   -------------

   function Is_Null
     (Container : in Container_Type;
      Name      : in Enum;
      Iteration : in Positive := 1) return Boolean is
   begin
      return Is_Null
               (Container => Container,
                Position  => Container.Index (Name),
                Iteration => Iteration);
   end Is_Null;

   -------------------------
   -- Name_Bind_Positions --
   -------------------------

   procedure Name_Bind_Positions
     (Container : in out Container_Type; Statement : in DB.Statement) is
   begin
      Container.Index := (others => 0);

      for J in 1 .. DB.Bind_Count (Statement) loop
         Container.Index (Enum'Value (DB.Bind_Name (Statement, J))) := J;
      end loop;
   end Name_Bind_Positions;

   ---------------------------
   -- Name_Define_Positions --
   ---------------------------

   procedure Name_Define_Positions
     (Container : in out Container_Type; Statement : in DB.Statement) is
   begin
      Container.Index := (others => 0);

      for J in 1 .. DB.Number_Of_Columns (Statement) loop
         Container.Index (Enum'Value (DB.Column_Name (Statement, J))) := J;
      end loop;
   end Name_Define_Positions;

   ---------
   -- Set --
   ---------

   procedure Set
     (Container : in out Container_Type;
      Item      : in     Integer;
      Name      : in     Enum;
      Iteration : in     Positive := 1) is
   begin
      Set
        (Container => Container,
         Item      => Item,
         Position  => Container.Index (Name),
         Iteration => Iteration);
   end Set;

   ---------
   -- Set --
   ---------

   procedure Set
     (Container : in out Container_Type;
      Item      : in     Long_Float;
      Name      : in     Enum;
      Iteration : in     Positive := 1) is
   begin
      Set
        (Container => Container,
         Item      => Item,
         Position  => Container.Index (Name),
         Iteration => Iteration);
   end Set;

   ---------
   -- Set --
   ---------

   procedure Set
     (Container : in out Container_Type;
      Item      : in     String;
      Name      : in     Enum;
      Iteration : in     Positive := 1) is
   begin
      Set
        (Container => Container,
         Item      => Item,
         Position  => Container.Index (Name),
         Iteration => Iteration);
   end Set;

   ---------
   -- Set --
   ---------

   procedure Set
     (Container : in out Container_Type;
      Item      : in     OCINumber;
      Name      : in     Enum;
      Iteration : in     Positive := 1) is
   begin
      Set
        (Container => Container,
         Item      => Item,
         Position  => Container.Index (Name),
         Iteration => Iteration);
   end Set;

   ---------
   -- Set --
   ---------

   procedure Set
     (Container : in out Container_Type;
      Item      : in     Ada.Calendar.Time;
      Name      : in     Enum;
      Iteration : in     Positive := 1) is
   begin
      Set
        (Container => Container,
         Item      => Item,
         Position  => Container.Index (Name),
         Iteration => Iteration);
   end Set;

   ---------
   -- Set --
   ---------

   procedure Set
     (Container : in out Container_Type;
      Item      : in     Lobs.Locator;
      Name      : in     Enum;
      Iteration : in     Positive := 1) is
   begin
      Set
        (Container => Container,
         Item      => Item,
         Position  => Container.Index (Name),
         Iteration => Iteration);
   end Set;

   ---------
   -- Set --
   ---------

   procedure Set
     (Container : in out Container_Type;
      Item      : in     Data_Holder;
      Name      : in     Enum;
      Iteration : in     Positive := 1) is
   begin
      Set
        (Container => Container,
         Item      => Item,
         Position  => Container.Index (Name),
         Iteration => Iteration);
   end Set;

end OCI.Thick.Containers.Enumeration;
