with OCI.Thread;

package body OCI.Thick.Parameters.Set is

   ------------
   -- Create --
   ------------

   function Create return Parameter is
      Result : Parameter;
   begin
      Result.Handle := Alloc_Descriptor (Thread.Environment, OCI_DTYPE_PARAM);
      return Result;
   end Create;

   ---------------
   -- Data_Size --
   ---------------

   procedure Data_Size (Param : in Parameter; Value : in Natural) is
      B2 : aliased constant Ub2 := Ub2 (Value);
   begin
      Set_Attr
        (H     => Param.Handle,
         HType => OCI_DTYPE_PARAM,
         Attr  => OCI_ATTR_DATA_SIZE,
         Value => B2'Address);
   end Data_Size;

   ---------------
   -- Data_Type --
   ---------------

   procedure Data_Type (Param : in Parameter; Value : in SQL_Type) is
   begin
      Set_Attr
        (H     => Param.Handle,
         HType => OCI_DTYPE_PARAM,
         Attr  => OCI_ATTR_DATA_TYPE,
         Value => Value'Address);
   end Data_Type;

   -------------
   -- Is_Null --
   -------------

   procedure Is_Null (Param : in Parameter; Value : in Boolean) is
      B1 : aliased constant Ub1 := Ub1 (Boolean'Pos (Value));
   begin
      Set_Attr
        (H     => Param.Handle,
         HType => OCI_DTYPE_PARAM,
         Attr  => OCI_ATTR_IS_NULL,
         Value => B1'Address);
   end Is_Null;

   ----------
   -- Name --
   ----------

   procedure Name (Param : in Parameter; Value : in String) is
   begin
      Set_Attr
        (H     => Param.Handle,
         HType => OCI_DTYPE_PARAM,
         Attr  => OCI_ATTR_NAME,
         Value => Value);
   end Name;

   ---------------
   -- Precision --
   ---------------

   procedure Precision (Param : in Parameter; Value : in Integer) is
      use System;
      use type Sb2;
      B2 : aliased constant Sb2 := Sb2 (Value);
      T2 : aliased Sb2 := -B2;
      B1 : aliased Ub1;
   begin
      Set_Attr
        (H     => Param.Handle,
         HType => OCI_DTYPE_PARAM,
         Attr  => OCI_ATTR_NAME,
         Value => B2'Address);

      if Default_Bit_Order = Low_Order_First then
         return;
      end if;

      --  Sb2 result type is for implicit describe by OCIStmtExecute()
      --  Ub1 result for explicit describe with OCIDescribeAny()
      --  Try to detect attribute size.

      Check_Error (OCIAttrGet
                     (Trgthndlp  => Param.Handle,
                      Trghndltyp => OCI_DTYPE_PARAM,
                      Attributep => T2'Address,
                      Sizep      => null,
                      Attrtype   => OCI_ATTR_PRECISION,
                      Errhp      => Thread.Error));

      if B2 /= T2 then
         B1 := Ub1 (Value);

         Set_Attr
           (H     => Param.Handle,
            HType => OCI_DTYPE_PARAM,
            Attr  => OCI_ATTR_NAME,
            Value => B1'Address);
      end if;
   end Precision;

   -----------
   -- Scale --
   -----------

   procedure Scale (Param : in Parameter; Value : in Integer) is
      B1 : aliased constant Sb1 := Sb1 (Value);
   begin
      Set_Attr
        (H     => Param.Handle,
         HType => OCI_DTYPE_PARAM,
         Attr  => OCI_ATTR_SCALE,
         Value => B1'Address);
   end Scale;

   -----------------
   -- Schema_Name --
   -----------------

   procedure Schema_Name (Param : in Parameter; Value : in String) is
   begin
      Set_Attr
        (H     => Param.Handle,
         HType => OCI_DTYPE_PARAM,
         Attr  => OCI_ATTR_SCHEMA_NAME,
         Value => Value);
   end Schema_Name;

   --------------
   -- Type_Code --
   --------------

   procedure Type_Code (Param : in Parameter; Value : in SQL_Type) is
   begin
      Set_Attr
        (H     => Param.Handle,
         HType => OCI_DTYPE_PARAM,
         Attr  => OCI_ATTR_TYPECODE,
         Value => Value'Address);
   end Type_Code;

   ---------------
   -- Type_Name --
   ---------------

   procedure Type_Name (Param : in Parameter; Value : in String) is
   begin
      Set_Attr
        (H     => Param.Handle,
         HType => OCI_DTYPE_PARAM,
         Attr  => OCI_ATTR_TYPE_NAME,
         Value => Value);
   end Type_Name;

end OCI.Thick.Parameters.Set;
