with Ada.Command_Line; use Ada.Command_Line;
with Ada.Text_IO;      use Ada.Text_IO;
with GNAT.OS_Lib;      use GNAT.OS_Lib;
with GNAT.Directory_Operations; use GNAT.Directory_Operations;

with Projects.Registry;    use Projects, Projects.Registry;
with Src_Info;             use Src_Info;
with Src_Info.Debug;       use Src_Info.Debug;
with Src_Info.CPP;         use Src_Info.CPP;

with Test_Utils;           use Test_Utils;
with Language_Handlers;    use Language_Handlers;
with Language_Handlers.Glide; use Language_Handlers.Glide;
with VFS;                  use VFS;

procedure Read_Many_ALI is

   Prj_Filename     : String_Access;
   Project          : Project_Type;
   Registry         : aliased Project_Registry;
   Source_Info_List : Src_Info.LI_File_List;
   LI_Unit          : LI_File_Ptr;
   Tmp_LI_Ptr       : LI_File_Ptr;
   Handler          : Language_Handler;

begin
   Handler := Create_Lang_Handler (Registry'Unchecked_Access);

   --  ??? We should enhance this test driver in the future in order
   --      to be able to test cases where the parser should fail.
   --      One way to do this is use command-line options, which will
   --      specify that a failure is expected, and even maybe an exception
   --      (with the exception name).

   if Argument_Count < 2 then
      Put_Line ("Invalid number of arguments.");
      Put_Line
        ("Usage: " & Command_Name & " <project_file> <source_filenames>");
      return;
   end if;

   Prj_Filename := new String'(Argument (1));
   if not Is_Regular_File (Prj_Filename.all) then
      Put_Line ("No such file: '" & Prj_Filename.all & "'");
      return;
   end if;

   Reset (Source_Info_List);
   Load_Project (Prj_Filename.all, Handler, Registry, Project);
   for I in 2 .. Argument_Count loop
      Put_Line ("*******************" & Argument (I)
         & "**********************");
      declare
         File : constant Virtual_File := Create
           (Normalize_Pathname (Argument (I), Get_Current_Dir));
         LI_Handler_Obj : constant LI_Handler := Get_LI_Handler_From_File
           (Glide_Language_Handler (Handler), File);
         LI_Filename : constant Virtual_File := LI_Filename_From_Source
           (LI_Handler_Obj, File, Project);
      begin
         LI_Unit := Locate (Source_Info_List, LI_Filename);
         Create_Or_Complete_LI
           (Handler                => LI_Handler_Obj,
            File                   => LI_Unit,
            Source_Filename        => File,
            List                   => Source_Info_List,
            Project                => Project);
--          Load_LI_File
--            (Source_Info_List  => Source_Info_List,
--             Handler           => Handler,
--             Project_View      => Project_View,
--             Source_Filename   => Argument (I),
--             LI                => LI_Unit);
         Tmp_LI_Ptr := Locate (Source_Info_List, LI_Filename);
         if Tmp_LI_Ptr = No_LI_File then
            Add (Source_Info_List, LI_Unit);
         end if;
         Src_Info.Debug.Dump_LI_File_Ptr (LI_Unit);
      end;
   end loop;
end Read_Many_ALI;
