-----------------------------------------------------------------------
--                               G P S                               --
--                                                                   --
--                        Copyright (C) 2004                         --
--                            ACT-Europe                             --
--                                                                   --
-- GPS is free  software;  you can redistribute it and/or modify  it --
-- under the terms of the GNU General Public License as published by --
-- the Free Software Foundation; either version 2 of the License, or --
-- (at your option) any later version.                               --
--                                                                   --
-- This program is  distributed in the hope that it will be  useful, --
-- but  WITHOUT ANY WARRANTY;  without even the  implied warranty of --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU --
-- General Public License for more details. You should have received --
-- a copy of the GNU General Public License along with this program; --
-- if not,  write to the  Free Software Foundation, Inc.,  59 Temple --
-- Place - Suite 330, Boston, MA 02111-1307, USA.                    --
-----------------------------------------------------------------------

with Ada.Command_Line; use Ada.Command_Line;
with GNAT.OS_Lib; use GNAT.OS_Lib;

function GPSLink return Integer is
   Args : Argument_List (1 .. Argument_Count + 1);
begin
   for J in 1 .. Args'Last - 1 loop
      Args (J) := new String'(Argument (J));
   end loop;

   --  Always link with libcommon.a last, so that it can resolve symbols
   --  not available in libgnat. This is needed to better support multiple
   --  versions of GNAT when building GPS.

   Args (Args'Last) := new String'("../../common/obj/libcommon.a");
   return Spawn (Locate_Exec_On_Path ("gcc").all, Args);
end GPSLink;
