#!/bin/sh

. ../CONFIG

gnatmake -q -Ptest_email

expect() {
  expected="$1"
  shift 1
  "$@" > out.$$ 2>&2
  if diff -u $expected out.$$ > diff.$$; then
     print_status 0
  else
     print_status 1
     cat diff.$$
  fi
  rm out.$$ diff.$$
}


## See man tzset(3) for more information on the format of this variable
## Let's go to newzealand
TZ="NZST-12"
export TZ
print_header "GNAT.Email (test_email)"
$valgrind ./test_email > out.$$
if test -s out.$$; then
   print_status 1
   cat out.$$
else
   print_status 0
fi
rm out.$$

print_header "GNAT.Email (multiple files in single mbox)"
$valgrind ./test_email4
print_status $?

print_header "GNAT.Email (composing)"
expect test_email3.expected ./test_email3

print_header "GNAT.Email (threading)"
expect test_email5.expected ./test_email5

print_header "GNAT.Email (splitted headers)"
expect test_email6.expected ./test_email6

