-----------------------------------------------------------------------
--                               G N A T L I B                       --
--                                                                   --
--                         Copyright (C) 2006-2008, AdaCore          --
--                                                                   --
-- GPS is free  software;  you can redistribute it and/or modify  it --
-- under the terms of the GNU General Public License as published by --
-- the Free Software Foundation; either version 2 of the License, or --
-- (at your option) any later version.                               --
--                                                                   --
-- This program is  distributed in the hope that it will be  useful, --
-- but  WITHOUT ANY WARRANTY;  without even the  implied warranty of --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU --
-- General Public License for more details. You should have received --
-- a copy of the GNU General Public License along with this program; --
-- if not,  write to the  Free Software Foundation, Inc.,  59 Temple --
-- Place - Suite 330, Boston, MA 02111-1307, USA.                    --
-----------------------------------------------------------------------

with Ada.Strings.Unbounded; use Ada.Strings.Unbounded;
with Ada.Text_IO;           use Ada.Text_IO;
with GNAT.Email.Parser;     use GNAT.Email, GNAT.Email.Parser;
with GNAT.Email.Mailboxes;  use GNAT.Email.Mailboxes;

procedure Test_Email6 is
   Box     : Mbox;
   Stored  : Stored_Mailbox;
   Iter    : Stored_Mailbox_Cursor;
   Subject : Unbounded_String;
   Msg     : Message;

   procedure My_Factory (Str : String; Msg : out Message);

   procedure My_Factory (Str : String; Msg : out Message) is
      pragma Unreferenced (Str);
   begin
      Put_Line ("Calling My_Factory, simulating parsing error");
      Msg := Null_Message;
   end My_Factory;

begin
   Open (Box, Filename => "email_data/email6");
   Store (Stored, Box, Factory  => Parse_No_Payload'Access);

   Sort_By_Date (Stored);

   --  Test the sorting of messages

   Iter := Stored_Mailbox_Cursor (First (Stored, Recurse => True));
   while Has_Element (Iter) loop
      Get_Message (Iter, Stored, Msg);

      if Msg /= Null_Message then
         To_String (Get_Header (Msg, "Subject"),
                    Max_Line_Len => 30,
                    Result => Subject);
         Put_Line (To_String (Subject));
      end if;

      Next (Iter, Stored);
   end loop;

   --  Test that we are indeed reading all messages entirely

   New_Line;

   Open (Box, Filename => "email_data/email6");
   declare
      Curs : Cursor'Class := First (Box);
   begin
      while Has_Element (Curs) loop
         Get_Message (Curs, Box, Msg);
         To_String (Msg, Result => Subject);  --  full message
         Put_Line (To_String (Subject));
         Next (Curs, Box);
      end loop;
   end;

   --  Test that the factory is really only called when the message is parsed

   New_Line;
   Open (Box, Filename => "email_data/email6");
   declare
      Curs : Cursor'Class := First (Box);
   begin
      Set_Parser (Curs, My_Factory'Unrestricted_Access);
      Next (Curs, Box);  --  Skip first message

      while Has_Element (Curs) loop
         Get_Message (Curs, Box, Msg);
         Next (Curs, Box);
      end loop;
   end;

end Test_Email6;
