/*

Copyright (c) 2000, Red Hat, Inc.

This file is part of Source-Navigator.

Source-Navigator is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your option)
any later version.

Source-Navigator is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License along
with Source-Navigator; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
MA 02111-1307, USA.

*/


/* AdaCore: Index in LexKeyWordTab is computed with the following
 * algorithm (see cplex.c for instance):
 *    char* word = "protected";
 *    int ihash=0, j=0;
 *    char* c;
 *    for (c=word; *c; c++) {
 *       if( j++ < 6 && ihash < HASH_MAX ) 
 *          ihash += c_hash[ (int) (*c)];
 *    }
 *    printf ("hash for %s is %d\n", word, ihash);
 */


#include "cpdefines.h"
#include "cpkeyw.h"

#define C_KEYWORD   0
#define CPP_KEYWORD 1

/* Hash tabla */

int c_hash[] =
{
    273,273,273,273,273,273,273,273,273,273,273,273,273,273,273,273,
    273,273,273,273,273,273,273,273,273,273,273,273,273,273,273,273,
    273,273,273,273,273,273,273,273,273,273,273,273,273,273,273,273,
    273,273,273,273,273,273,273,273,273,273,273,273,273,273,273,273,
    273,273,273,273,273,273,273,273,273,273,273,273,273,273,273,273,
    273,273,273,273,273,273,273,273,273,273,273,273,273,273,273,273,
    273, 14, 15,  7, 35, 49, 48, 37, 22, 34,  7, 48, 44,  5,  6, 30,
      8, 11, 32, 45, 46, 40, 27, 11, 39, 30, 40,273,273,273,273,273,
    273,273,273,273,273,273,273,273,273,273,273,273,273,273,273,273,
    273,273,273,273,273,273,273,273,273,273,273,273,273,273,273,273,
    273,273,273,273,273,273,273,273,273,273,273,273,273,273,273,273,
    273,273,273,273,273,273,273,273,273,273,273,273,273,273,273,273,
    273,273,273,273,273,273,273,273,273,273,273,273,273,273,273,273,
    273,273,273,273,273,273,273,273,273,273,273,273,273,273,273,273,
    273,273,273,273,273,273,273,273,273,273,273,273,273,273,273,273,
    273,273,273,273,273,273,273,273,273,273,273,273,273,273,273,273,
};

KYW_S  LexKeyWordTab[] =
{
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { "asm"         , SN_ASM       , CPP_KEYWORD , 3 },
    { "do"          , SN_DO        , C_KEYWORD   , 2 },
    { "new"         , SN_NEW       , CPP_KEYWORD , 3 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { "char"        , SN_CHAR      , C_KEYWORD   , 4 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { "if"          , SN_IF        , C_KEYWORD   , 2 },
    { 0 },
    { 0 },
    { 0 },
    { "int"         , SN_INT       , C_KEYWORD   , 3 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { "catch"       , SN_CATCH     , CPP_KEYWORD , 5 },
    { 0 },
    { 0 },
    { 0 },
    { "enum"        , SN_ENUM      , C_KEYWORD   , 4 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { "try"         , SN_TRY       , CPP_KEYWORD , 3 },
    { 0 },
    { "for"         , SN_FOR       , C_KEYWORD   , 3 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { "case"        , SN_CASE      , C_KEYWORD   , 4 },
    { "union"       , SN_UNION     , C_KEYWORD   , 5 },
    { "long"        , SN_LONG      , C_KEYWORD   , 4 },
    { 0 },
    { "bool"        , SN_BOOL      , CPP_KEYWORD , 4 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { "void"        , SN_VOID      , C_KEYWORD   , 4 },
    { "namespace"   , SN_NAMESPACE , CPP_KEYWORD , 9 },
    { 0 },
    { "continue"    , SN_CONTINUE  , C_KEYWORD   , 8 },
    { "auto"        , SN_AUTO      , C_KEYWORD   , 4 },
    { 0 },
    { 0 },
    { 0 },
    { "const"       , SN_CONST     , C_KEYWORD   , 5 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { "throw"       , SN_THROW     , CPP_KEYWORD , 5 },
    { 0 },
    { "goto"        , SN_GOTO      , C_KEYWORD   , 4 },
    { 0 },
    { 0 },
    { 0 },
    { "this"        , SN_THIS      , CPP_KEYWORD , 4 },
    { "public"      , SN_PUBLIC    , CPP_KEYWORD , 6 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { "class"       , SN_CLASS     , CPP_KEYWORD , 5 },
    { 0 },
    { 0 },
    { "break"       , SN_BREAK     , C_KEYWORD   , 5 },
    { 0 },
    { "while"       , SN_WHILE     , C_KEYWORD   , 5 },
    { "private"     , SN_PRIVATE   , CPP_KEYWORD , 7 },
    { "using"       , SN_USING     , CPP_KEYWORD , 5 },
    { 0 },
    { 0 },
    { "switch"      , SN_SWITCH    , C_KEYWORD   , 6 },
    { "template"    , SN_TEMPLATE  , CPP_KEYWORD , 8 },
    { 0 },
    { "unsigned"    , SN_UNSIGNED  , C_KEYWORD   , 8 },
    { 0 },
    { 0 },
    { 0 },
    { "protected"   , SN_PROTECTED , CPP_KEYWORD , 9 },
    { "inline"      , SN_INLINE    , CPP_KEYWORD , 6 },
    { 0 },
    { "short"       , SN_SHORT     , C_KEYWORD   , 5 },
    { 0 },
    { 0 },
    { 0 },
    { "operator"    , SN_OPERATOR  , CPP_KEYWORD , 8 },
    { 0 },
    { 0 },
    { "float"       , SN_FLOAT     , C_KEYWORD   , 5 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { "else"        , SN_ELSE      , C_KEYWORD   , 4 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { "static"      , SN_STATIC    , C_KEYWORD   , 6 },
    { "virtual"     , SN_VIRTUAL   , CPP_KEYWORD , 7 },
    { 0 },
    { "volatile"    , SN_VOLATILE  , CPP_KEYWORD , 8 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { "friend"      , SN_FRIEND    , CPP_KEYWORD , 6 },
    { "return"      , SN_RETURN    , C_KEYWORD   , 6 },
    { "signed"      , SN_SIGNED    , C_KEYWORD   , 6 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { "overload"    , SN_OVERLOAD  , CPP_KEYWORD , 8 },
    { "double"      , SN_DOUBLE    , C_KEYWORD   , 6 },
    { 0 },
    { "interface"   , SN_INTERFACE , CPP_KEYWORD , 9 },
    { "struct"      , SN_STRUCT    , C_KEYWORD   , 6 },
    { "typedef"     , SN_TYPEDEF   , C_KEYWORD   , 7 },
    { 0 },
    { 0 },
    { 0 },
    { "extern"      , SN_EXTERN    , C_KEYWORD   , 6 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { "default"     , SN_DEFAULT   , C_KEYWORD   , 7 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { "register"    , SN_REGISTER  , C_KEYWORD   , 8 },
    { 0 },
    { 0 },
    { "sizeof"      , SN_SIZEOF    , C_KEYWORD   , 6 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { 0 },
    { "delete"      , SN_DELETE    , CPP_KEYWORD , 6 },
};
                             

