/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
//FILE: main.h - variable declarations for main.cpp (note: many of these are shared with other files via gnaural.h)
#define GNAURAL_GUIMODE 0
#define GNAURAL_USEDEFAULTSOUNDDEVICE -255

//main window:
GtkWidget *window1;
CBinauralBeat *bb = NULL;
PortAudioStream *gnaural_pa_stream = NULL;      //this will equal NULL if the sound system wasn't detected, so use to check
PaDeviceID gnaural_pa_SoundDevice = GNAURAL_USEDEFAULTSOUNDDEVICE;
//pthread_t gnaural_thread_WriteEngineWAV;
GThread *gnaural_thread_WriteEngineWAV;
char *gnaural_writefilename = NULL;     //this will equal NULL if a file is NOT being written to
int gnaural_pauseflag = (~0);   //pauseflag is critical: basically controls all movement through schedule, also stops and starts sound
int gnaural_guiflag = GNAURAL_GUIMODE;  //set to GNAURAL_GUIMODE to indicate that GUI is in use; otherwise command-line is assumed
int gnaural_ManualFreqBaseControl = FALSE;
float gnaural_FreqBase_old = 140.0;
float gnaural_OverallVolume = 1.f;      //this solely mirrors the OverallVolume slider; don't set
float gnaural_OverallBalance = 0.f;     //this solely mirrors the OverallBalance slider; don't set

//general string that can be written to at any time by anything
//so long as "anything" isn't in a different thread
char gnaural_tmpstr[PATH_MAX + PATH_MAX + 1];

//my getopt() vars/flags: 
#define GNAURAL_CMDLINEOPTS     ":w:a:sodpih"
int cmdline_w = 0;              //Output .WAV file directly to file
int cmdline_a = 0;              //tell Gnaural which sound HW to access
int cmdline_s = 0;              //Create fresh Schedule file flag
int cmdline_o = 0;              //Output .WAV directly to stdout
int cmdline_d = 0;              //Show debugging information
int cmdline_p = 0;              //Output to sound system
int cmdline_i = 0;              //Show detailed console information 
//  int cmdline_h = 0; //show help [not actually needed, since it is handled during parsing]

//how often to update informational text labels
#define DISPLAY_REFRESH_TIME 1000

//informational text labels I need to be able to modify:
GtkLabel *LabelProgramStatus;
GtkLabel *LabelFilename;
GtkLabel *LabelOverallRuntime;
GtkLabel *LabelOverallCurrentTime;
GtkLabel *LabelCurEntryNumber;
GtkLabel *LabelCurEntryDuration;
GtkLabel *LabelCurEntryCountdown;
GtkLabel *LabelCurEntryHzRange;
GtkLabel *LabelCurEntryLeftStartHz;
GtkLabel *LabelCurEntryRightStartHz;
GtkLabel *LabelCurEntryRightEndHz;
GtkLabel *LabelCurEntryLeftEndHz;
GtkLabel *LabelFreqBeat;
GtkLabel *LabelFreqRight;
GtkLabel *LabelFreqBase;
GtkLabel *LabelFreqLeft;
GtkLabel *LabelPlay_Pause;
GtkProgressBar *ProgressBar_Overall;
GtkRange *RangeVolumeTone;
GtkRange *RangeVolumeNoise;
GtkRange *RangeFreqBeat;
GtkRange *RangeFreqBase;
GtkStatusbar *StatusBar_main;

char szGnauralHelpShort[] = "Try `gnaural -h' for more information.\n";

char szGnauralHelp[] = "A programmable binaural beat\n\
and pink noise generator. Outputs in stereo 44.1khz PCM WAV\n\
format following directives in ~/.gnaural/gnaural_schedule.txt.\n\
For more info see:\n\
\thttp://gnaural.sourceforge.net/\n\
===Command Line Options===\n\
 -w [file.wav] \twrite output to a .WAV file\n\
 -o \t\twrite output to stdout (for redirection)\n\
 -p \t\tplay output through sound system\n\
 -a [0 to 9] \tspecify sound card (optional)\n\
 -s \t\tcreate default file ~/.gnaural/gnaural_schedule.txt\n\
 -i \t\tshow runtime info on screen (use with -p or -w)\n\
 -d \t\toutput debug info\n\
 -h \t\tshow this info\n\
===Examples===\n\
 Create a CD-compatible WAV file:\n\
\tgnaural -iw MyMeditation.wav\n\
 Play directly through sound system:\n\
\tgnaural -pi\n\
 Pipe Gnaural through LAME to create an MP3:\n\
\tgnaural -o | lame - MyMeditation.mp3\n\
";

char GnauralIcon[4648] = {
 -119, 80, 78, 71, 13, 10, 26, 10, 0, 0, 0, 13, 73, 72, 68, 82, 0, 0, 0, 48,
 0, 0, 0, 48, 8, 6, 0, 0, 0, 87, 2, -7, -121, 0, 0, 0, 4, 115, 66, 73,
 84, 8, 8, 8, 8, 124, 8, 100, -120, 0, 0, 17, -33, 73, 68, 65, 84, 104, -127,
 -19,
 90, 121, 88, 84, -25, -71, -1, -99, 101, -50, -20, 48, -52, 42, -101, -128,
 -78, -90, 10, 17,
 80, 16, 4, -58, -107, 6, 101, 105, -52, -90, 49, -82, 13, 94, -91, 49, -74,
 49, -113, 105,
 19, 115, -45, -44, -104, -74, -15, 54, 73, 53, 38, -10, -38, -12, 90, -67,
 49, 54, 54, 53,
 79, 110, 106, -116, 105, 82, 113, 37, -126, 50, 16, 54, 81, 22, 29, 103, 24,
 -61, 12, -52,
 -64, 44, -52, -103, 115, -50, -3, -61, 12, 1, 102, -44, 110, 79, -17, -3,
 -93, -17, -13, 124,
 -49, 51, -25, -68, -17, -7, -66, -33, 123, -34, -11, -5, -50, 0, -1, -94, -1,
 91, 34, -2,
 17, -109, 108, -36, -72, 81, -44, -35, -35, 93, -39, -41, -41, -73, -48, -29,
 -15, 68, 19, 4,
 -63, 27, 12, -122, 47, 82, 82, 82, -34, -40, -73, 111, -97, 51, 40, 87, 86,
 86, 86, -54,
 -13, 60, 53, 101, -54, -108, 51, 123, -10, -20, 113, -34, 105, -50, 127, 26,
 -51, -97, 63, -1,
 -31, -55, -109, 39, -9, 49, 12, 35, 16, 4, 33, 0, 16, 0, 8, 52, 77, 11, 25,
 25,
 25, -41, -85, -85, -85, 35, -125, -78, 25, 25, 25, 22, -111, 72, 36, 104, 52,
 -102, 64, 82,
 82, -46, -23, -62, -62, -62, 77, 107, -42, -84, 81, -1, -45, 65, 87, 85, 85,
 101, 86, 84,
 84, 60, 93, 94, 94, 94, -93, 86, -85, 3, 65, -48, 19, 7, -61, 48, -62, -110,
 37, 75,
 -98, 1, -128, -89, -97, 126, 90, 22, 27, 27, 59, -114, 79, 16, -124, -96,
 -45, -23, -36, -103,
 -103, -103, -69, -41, -84, 89, -93, -3, 91, -80, -48, 127, -115, -16, -86,
 85, -85, -44, -11, -11,
 -11, 47, 127, -2, -7, -25, -21, 40, -118, -94, 0, -64, -25, -13, 65, -87, 84,
 98, 104, 104,
 40, 68, 62, 16, 8, -64, 110, -73, 39, 1, -128, -35, 110, 79, 114, -71, 92,
 -29, -8, -126,
 32, -32, -85, -81, -66, -110, 13, 15, 15, -41, 76, -99, 58, -11, 12, -128,
 67, -1, 80, 5,
 -94, -75, 74, 112, 28, 15, -113, -113, 69, 126, 97, -79, -15, -60, -119, 19,
 7, -84, 86, 107,
 -100, 32, 8, 0, 0, -83, 86, -117, 5, 11, 22, 60, 70, -110, -92, -17, -12,
 -23, -45, -17,
 -11, -9, -9, -121, 0, -28, 56, 14, 0, -32, 112, 56, 102, 120, -67, -34, -80,
 -21, -80, 44,
 11, -109, -55, -12, 78, 82, 82, -46, 94, -119, 68, -46, -104, -100, -100, -4,
 -38, -121, 31, 126,
 -8, -2, 95, -85, 76, 88, 82, 72, 69, -56, -49, -49, -81, -119, -120, -120, 8,
 113, -107, -72,
 -72, 56, 97, -61, -122, 13, -55, 0, -112, -99, -99, 109, 26, 27, 3, -8, -38,
 69, 10, 11,
 11, -9, 2, 64, 97, 97, -31, 11, 36, 73, -122, -72, -103, 88, 44, 22, -46,
 -45, -45, 59,
 39, 79, -98, -4, 85, -112, -81, 84, 42, -123, -126, -126, -126, -73, -97,
 124, -14, 73, -22, 110,
 -8, -56, -69, 9, 100, -50, -104, 89, 99, 50, -103, 118, -69, 92, -82, -112,
 -55, 108, 54, 27,
 58, 59, 59, -41, 45, -101, -85, -123, 94, -81, 63, 36, 18, -119, -58, -15, 9,
 -126, 0, -57,
 113, 54, 0, 24, 30, 30, -2, 22, -49, -13, 33, -4, -76, -76, -76, 43, -91,
 -91, -91, -71,
 70, -93, 113, -74, 86, 123, 43, 12, -122, -122, -122, -48, -48, -48, -80,
 -90, -95, -95, -31, -11,
 -65, 91, -127, -56, -56, 72, -89, 92, 46, -25, -62, -15, 88, -106, 69, 87,
 87, -41, 26, 125,
 -26, -93, -111, -15, -15, -15, -121, 53, 26, 77, -120, 12, -61, 48, 60, 0,
 -72, -35, -18, -116,
 48, 115, 99, -22, -44, -87, 79, -66, -2, -6, -21, 78, -113, -57, -109, -23,
 -9, -5, 71, 121,
 35, 35, 35, 104, 110, 110, -82, -87, -86, -86, 42, -70, 27, -58, -69, -46,
 -30, -59, -117, 87,
 -24, 116, -70, -80, -39, -122, 97, 24, -95, -76, -76, -12, -23, -70, -99, 9,
 -56, -52, -52, 60,
 55, -106, 71, -110, -92, 48, 103, -50, -100, 77, -37, -74, 109, -93, -30,
 -30, -30, -36, -104, -32,
 94, 57, 57, 57, -97, 0, -64, -54, -107, 43, 19, -46, -45, -45, 45, -31, 92,
 48, 43, 43,
 -21, -67, 59, 97, 11, 107, -127, -86, -86, -86, -124, -62, -62, -62, -38, 21,
 43, 86, 20, 2,
 -64, 71, 31, 125, 116, 48, 47, 47, -17, 81, -83, 86, -21, -101, 40, -21, -9,
 -5, 113, -11,
 -22, -43, -102, 67, -26, -17, -120, 52, 26, -51, 97, -102, -2, 38, 47, 16, 4,
 1, -118, -94,
 124, 54, -101, 45, -55, -27, 114, -55, -58, 62, 39, 22, -117, -95, -45, -23,
 -84, 37, 37, 37,
 -101, 79, -97, 62, 125, -6, -14, -27, -53, -47, -63, -28, 16, 36, 65, 16,
 -32, -13, -7, 66,
 44, 119, 87, 74, 79, 79, -81, -91, 40, 74, 72, 74, 74, 10, 84, 84, 84, 108,
 126, -2,
 -7, -25, 41, 0, 88, -72, 112, 97, -87, 86, -85, -11, 34, 76, 32, -34, 119,
 -33, 125, -21,
 86, -81, 94, -99, 48, -42, 82, 20, 69, 9, -59, -59, -59, 15, -108, -105,
 -105, 23, -119, 68,
 -94, 16, -21, -47, 52, 45, -124, 11, -20, -79, -4, -110, -110, -110, -35,
 119, -62, 26, 98, -127,
 -123, 11, 23, 62, -36, -43, -43, 85, -60, 113, 28, 122, 122, 122, -88, 83,
 -89, 78, -67, 122,
 -14, -28, -55, 119, -85, -85, -85, -107, 39, 78, -100, 56, -98, -101, -101,
 91, -91, -41, -21, -57,
 89, 98, 100, 100, 4, 87, -82, 92, -7, 126, 124, 124, -68, 89, -89, -45, -99,
 13, -34, 15,
 90, -64, -19, 118, 103, 4, 2, -127, 81, 121, -119, 68, -126, 73, -109, 38,
 57, 85, 42, 21,
 -58, 90, 108, 44, 41, 20, 10, -52, -102, 53, -21, -3, -84, -84, -84, 45, 119,
 82, 96, 92,
 102, -39, -78, 101, -117, -88, -74, -74, -10, -9, 14, -121, 99, -76, -68, -5,
 124, 62, 88, -83,
 -42, 123, 124, 62, -33, 35, -13, -26, -51, -5, -4, -24, -47, -93, 103, -115,
 70, -29, 23, 78,
 -89, -13, 65, -73, -37, 61, -70, -70, -41, -21, -43, -117, -59, 98, -109, 88,
 44, -18, -67, 118,
 -19, 90, -103, 32, 8, -96, 40, 10, -23, -23, -23, -121, -20, 118, 123, -122,
 -59, 98, 41, 1,
 0, -102, -90, -111, -101, -101, -5, 74, 113, 113, -15, -30, -108, -108, -108,
 58, -75, 90, 125, -116,
 97, 24, 53, -57, 113, -119, 44, -53, -126, 36, 73, -60, -59, -59, 57, -14,
 -14, -14, 106, 62,
 -5, -20, -77, 31, -42, -43, -43, 5, 0, 96, -3, -6, -11, -87, 9, 9, 9, 11,
 -38, -38,
 -38, 90, 110, -85, -51, -68, 121, -13, 42, 41, -118, 10, 107, 78, -110, 36,
 -123, -8, -8, 120,
 111, 105, 105, -23, -54, -91, 75, -105, 98, -15, -30, -59, 69, 58, -99, 110,
 112, -84, -52, -44,
 -87, 83, 79, -81, 92, -71, 50, 70, -93, -47, 4, -16, 117, -128, 87, 86, 86,
 -50, -53, -54,
 -54, -38, 27, -108, 73, 76, 76, -76, -44, -44, -44, 72, 114, 115, 115, -33,
 -47, -23, 116, -127,
 -46, -46, -46, 13, 0, -80, 106, -43, -86, -28, -110, -110, -110, -89, 22, 44,
 88, -80, -7, -69,
 -33, -3, -18, 104, -1, -76, 122, -11, -22, 4, -93, -47, 120, 32, 62, 62, 62,
 16, 21, 21,
 21, 88, -70, 116, 105, -62, 109, 21, 72, 73, 73, -7, 83, 56, -16, 99, -121,
 82, -87, 20,
 10, 11, 11, -9, 111, -36, -72, 81, 82, 90, 90, 58, 75, -81, -41, -113, 42,
 33, -109, -55,
 -124, -54, -54, 74, 99, 90, 90, -38, -25, 0, 4, -119, 68, 34, -108, -105,
 -105, -25, 100, 101,
 101, -67, 26, -108, -103, 57, 115, -26, -49, 75, 74, 74, 54, 72, -91, 82, 1,
 -128, -96, 86,
 -85, -123, -78, -78, -78, -5, -25, 102, 50, -29, -80, -84, 93, -69, 54, -95,
 -72, -72, -8, -19,
 -40, -40, 88, 127, -16, -91, 18, 4, 33, -36, 123, -17, -67, 63, 15, -21, 66,
 79, 60, -15,
 -124, -46, 100, 50, -67, -23, 118, -69, -55, -119, -39, 96, 44, -7, -3, 126,
 88, -83, -42, -84,
 -63, -63, -63, -118, -40, -40, -40, -73, 13, 6, -61, -5, 46, -105, -21, 33,
 -73, -37, 45, 97,
 89, 22, -126, 32, -60, 106, 52, -102, -33, 89, -83, -42, 114, -119, 68, -126,
 -84, -84, -84, 95,
 1, 64, 79, 79, 79, -91, 32, 8, -32, 121, 126, 86, 79, 79, 79, -123, -57, -29,
 25, -99,
 47, 42, 42, -118, -3, 118, -38, -32, 31, 102, 76, 21, 33, -67, -32, -47, 56,
 -103, 76, -10,
 -54, -123, 11, 23, -34, 110, 107, 107, -53, 113, -71, 92, -44, 88, 60, 20,
 69, -59, 13, 13,
 13, -67, 22, -94, -64, -94, 69, -117, 56, -79, 88, -36, -94, 82, -87, 56,
 -103, 76, 22, -53,
 113, -100, -12, 107, 64, 33, 74, -16, 60, 15, -121, -61, 97, 112, 56, 28,
 -85, -75, 90, -19,
 -55, -8, -8, -8, -99, 78, -89, -13, 126, -73, -37, -83, -96, 105, 58, -47,
 104, 52, 62, -91,
 -47, 104, 46, 79, -101, 54, -19, 63, -30, -29, -29, -21, 24, -122, -23, -20,
 -17, -17, 95, -19,
 116, 58, -107, -61, -61, -61, 20, -53, -78, 32, 8, 2, 58, -99, -50, 57, 99,
 -58, -116, 31,
 22, 20, 20, 60, 119, -125, 77, -116, -71, -40, 67, -66, 82, 95, 95, -1, 95,
 29, 29, 29,
 -77, -122, -122, -122, -88, 112, 107, -77, 44, -85, 122, -24, -95, -121, -2,
 -48, -36, -36, 108, 3,
 38, 108, 104, -42, -81, 95, 15, -125, -63, 0, -106, 101, 69, -99, -99, -99,
 57, 125, 125, 125,
 101, 14, -121, -93, -14, -26, -51, -101, -103, 3, 3, 3, -93, -115, -39, 88,
 82, 40, 20, 72,
 75, 75, 123, 77, -89, -45, -19, -69, 118, -19, -38, 59, -119, -119, -119, 59,
 -98, 123, -18, -71,
 -61, 50, -103, 12, 82, -87, 20, 95, 55, -83, 120, -22, -87, -89, -110, -81,
 92, -71, -14, -78,
 -41, -21, 77, 37, 73, -46, -84, -43, 106, -1, -100, -102, -102, -6, 91, -122,
 97, 96, 50, -103,
 -74, -11, -12, -12, -84, -79, -37, -19, -78, -119, -19, -58, 68, 34, 8, 2, 5,
 5, 5, -33,
 63, 115, -26, -52, 107, 33, -52, -3, -5, -9, -61, 102, -77, 65, 16, -124,
 -47, 78, -46, -23,
 116, -94, -70, -70, 58, 110, -50, -100, 57, 53, 105, 105, 105, 95, -46, 52,
 29, 18, 23, 20,
 69, 9, -103, -103, -103, 31, -99, 62, 125, 26, -105, 46, 93, 66, 123, 123,
 59, 58, 58, 58,
 -48, -39, -39, -119, -85, 87, -81, -94, -69, -69, 27, -67, -67, -67, -24,
 -19, -19, -59, -48, -48,
 16, -6, -38, -34, -59, -58, -115, 27, -87, -4, -4, -4, 103, 12, 6, -125, -21,
 78, -75, 32,
 -36, -56, -56, -56, -40, 31, -60, 60, 46, 9, -81, 92, -71, 18, -64, -83, 62,
 62, -24, -93,
 -19, -19, -19, 88, -66, 124, -71, 25, -64, 27, 71, -113, 30, -3, -43, -79,
 99, -57, -2, -44,
 -47, -47, 49, -38, -97, 48, 12, 3, -98, -25, 33, -105, -53, -69, 85, 42, 21,
 72, 114, 124,
 105, 9, 94, 11, -126, 0, -102, -90, -31, 114, -71, -16, -22, -81, -21, 37,
 -97, 126, -6, -23,
 -17, -81, 94, -67, 90, 22, -50, -86, 19, -33, 56, 73, -110, 16, -119, 68, 96,
 24, 6, 10,
 -123, 2, 81, 81, 81, -122, 16, 5, -28, 114, 57, 120, -98, -121, -37, -19, 6,
 -57, 113, 104,
 105, 105, -63, -40, -30, 3, 0, 85, 85, 85, 108, 99, 99, -29, -119, 43, 87,
 -82, 20, 5,
 23, -42, -23, 116, 72, 77, 77, 125, 35, 38, 38, -26, 39, 19, -127, 7, -25,
 11, 4, 2,
 -120, -116, -116, 4, 73, -110, 32, 73, 18, 23, 46, 92, 88, -41, -43, -43, 53,
 10, -98, -94,
 40, 48, 12, 3, -71, 92, 14, -71, 92, -18, -93, 105, -6, -102, 88, 44, -74,
 48, 12, 99,
 22, -117, -59, -35, 98, -79, -40, -84, -47, 104, -6, 85, 42, -107, 37, 42,
 42, -54, -6, -117,
 95, -4, -94, 55, 68, 1, -73, -37, -115, 27, 55, 110, -64, -21, -11, 98, 96,
 96, 96, 28,
 120, -114, -29, -32, -11, 122, 49, 60, 60, -116, -88, -88, -88, -9, -45, -46,
 -46, 12, 126, -65,
 95, 73, 81, -44, 100, -81, -41, -85, -28, 121, -2, 91, 91, -73, 110, -75, 5,
 -27, -3, 126,
 63, -68, 94, 47, -92, 82, 41, -92, 82, 41, 20, 10, -59, -72, -118, 43, 22,
 -117, -49, 76,
 -102, 52, -55, 97, -75, 90, -43, 83, -90, 76, 57, -97, -106, -106, -10, -118,
 90, -83, -66, -94,
 86, -85, 109, -123, 121, -103, -74, -84, 25, -77, 49, -119, -32, -31, -70,
 112, 22, -34, -53, 45,
 24, -2, -14, 34, -114, 93, 109, -124, 90, 42, -63, -65, -99, 111, 27, 111,
 -95, -79, 23, 21,
 21, 21, -107, 102, -77, -71, 92, 16, 4, -3, -41, 41, -49, -87, 86, -85, -49,
 -49, -104, 49,
 -29, -41, -13, -25, -49, -9, 29, 58, 116, 40, -93, -87, -87, -23, 101, -114,
 -29, 72, -118, -94,
 -100, 34, -111, -24, 66, 114, 114, -14, 7, 63, -6, -47, -113, 122, -127, 91,
 -19, 53, -53, -78,
 8, 6, 48, 77, -45, -96, 40, 106, -12, -51, -109, 36, 9, -118, -94, -80, 115,
 -25, 78, -55,
 -89, -97, 126, 106, 106, 111, 111, 79, -115, -120, -120, -24, 87, -87, 84,
 -25, 40, -118, 114, -14,
 60, -17, -103, 40, 59, -10, -102, -90, 105, -112, 36, 9, -119, 68, 98, 61,
 113, -30, -60, 11,
 -29, 52, 41, 45, 45, 93, -95, 86, -85, -61, -74, -53, -71, -71, -71, -17,
 -42, -42, -42, -30,
 -111, 71, 30, 41, -109, 72, 36, -29, -38, 93, -75, 90, 29, -56, -50, -50,
 -34, 87, 93, 93,
 45, 105, 104, 104, 64, 107, 107, -21, -72, -32, -19, -23, -23, 65, 79, -3,
 86, -54, 98, -79,
 -64, 108, 54, -61, 108, 54, 99, -19, -38, -75, 57, 74, -91, -14, -74, 65, 74,
 16, -60, -24,
 32, 73, 114, 116, 80, 20, 37, 80, 20, 37, -24, -11, 122, 75, -120, 11, -103,
 -51, -26, 39,
 28, 14, 7, 38, -110, -33, -17, 71, 107, 107, -21, -61, -37, -73, 111, -1, 32,
 57, 57, -7,
 -126, 92, 46, -121, -49, -9, 77, 47, -25, 112, 56, 40, -89, -45, -71, -114,
 -94, -88, 65, -71,
 92, -66, -123, 32, 110, 25, 117, -61, -122, 13, 15, 36, 36, 36, 28, 127, -10,
 -39, 103, -121,
 12, -12, -57, 3, -108, -3, -93, -77, 44, -89, 56, -52, 75, 115, 15, 15, 14,
 14, 114, 26,
 -115, -58, -20, -9, -5, -29, 70, 70, 70, 66, -42, 28, -101, -1, -61, -43, 2,
 -122, 97, -36,
 -63, -33, -93, 41, -61, -29, -15, 100, -122, 72, 126, -61, 67, 75, 75, -53,
 -101, 14, -121, -125,
 -43, -21, -11, -74, -24, -24, -24, -95, -116, -116, -116, -9, -13, -13, -13,
 127, 26, 17, 17, 1,
 -114, -29, 96, -73, -37, -17, 15, -54, 63, -2, -8, -29, -91, -11, -11, -11,
 -17, 121, 60, -98,
 104, -106, 101, -63, -112, 118, -91, -120, -65, 94, 42, 35, -38, -33, -106,
 -116, -4, -47, 114, -32,
 -7, -21, 43, -50, -3, 46, 103, -114, -47, 104, 92, -100, -106, -106, -10,
 -66, 94, -81, 103, -125,
 -11, -30, 47, 33, -119, 68, 98, 13, -2, 30, -75, 0, 77, -45, -94, -16, -30,
 -73, -56, 98,
 -79, 68, 54, 53, 53, 125, -108, -105, -105, -73, 84, 42, -107, 54, -71, -35,
 110, -27, -105, 95,
 126, -71, 43, -104, 110, 1, -40, 0, -32, -59, 23, 95, -44, -74, -75, -75,
 -19, -93, 40, -86,
 63, 38, 38, -90, -5, 86, 26, 37, -63, 11, 52, 2, -124, -63, -55, 8, -106, 72,
 -102, -80,
 63, 69, -47, -74, -102, -9, 126, 26, -5, 22, -49, -52, 121, 116, -53, -85,
 68, 100, 71, 71,
 -57, 26, -85, -43, -70, -58, 102, -77, -91, -70, -35, 110, -36, -87, -96, 73,
 -91, -46, 47, 66,
 110, 102, 100, 100, -76, 98, -62, 102, -62, 96, 48, 8, 41, 41, 41, -10, -8,
 -8, 120, -73,
 72, 36, 18, 72, -110, 20, -110, -110, -110, 122, -90, 79, -97, 126, -44, 96,
 48, 120, -125, 91,
 64, -110, 36, -123, -68, -68, -68, 77, 77, 77, 77, -72, -25, -98, 123, 14, 0,
 16, -30, -29,
 -29, 63, -18, -23, -23, -127, -39, 108, 6, 103, -118, 117, -15, 38, -115, 48,
 -48, 88, -75, -62,
 115, -23, -98, 86, -63, 20, 41, 8, -90, 72, -127, 107, -98, -30, 30, 106,
 125, 44, -63, -29,
 -15, -64, -29, -15, -64, -17, -9, -29, -63, 7, 31, 52, -26, -26, -26, -66,
 -109, -112, -112, -32,
 -107, 72, 36, -62, -60, 109, 38, 73, -110, -62, -94, 69, -117, -106, 5, 113,
 -113, -70, -112, 74,
 -91, 58, 30, 44, 58, 74, -91, 18, 69, 69, 69, -65, -82, -88, -88, 72, -21,
 -20, -20, -44,
 84, 85, 85, 105, 102, -51, -102, -11, 33, 73, -110, -24, -18, -18, 78, 104,
 110, 110, -82, -76,
 -39, 108, -110, -96, 127, 78, -98, 60, -71, 109, -10, -20, -39, -5, 54, 109,
 -38, -76, -84, -85,
 -85, 107, -59, -41, 125, 78, 109, 112, 62, 63, 47, 27, 38, 16, -128, -104,
 111, -33, -26, 38,
 102, 46, 29, -31, -75, 54, 16, 82, 14, -30, -108, -11, 126, -61, 107, -67,
 -127, -85, 15, 45,
 11, -76, -26, 93, 119, 54, -106, -82, -39, -11, -84, -2, -52, -111, 35, 71,
 -106, 47, 89, -78,
 100, -46, -36, -71, 115, -97, -100, 62, 125, 122, -109, 94, -81, -121, 72,
 36, 2, 65, 16, 80,
 42, -107, 92, 92, 92, -36, 103, 65, -36, -93, -114, 103, 52, 26, -37, -5, -6,
 -6, 106, -36,
 110, 55, 21, 23, 23, -41, 127, -23, -46, -91, -94, -117, 23, 47, -38, -41,
 -83, 91, 23, -45,
 -38, -38, -6, -109, -18, -18, -18, -121, -61, 29, -83, -24, 116, 58, 103,
 126, 126, -2, 98, -98,
 -25, 81, 87, 87, -9, -31, -32, -32, -96, -108, 97, 24, 100, 103, 103, 111,
 47, 43, 43, -21,
 -95, 40, 10, -52, -16, -95, 50, -122, 116, 37, -47, -92, 91, -29, -25, 36,
 -50, 17, 97, -14,
 75, 34, -119, -18, -92, 39, -6, 119, 7, 73, -53, -90, 100, 25, 111, -6, -125,
 -108, -76, 24,
 104, -36, -84, 20, 88, -5, 3, -124, -25, 108, -17, -108, 25, -101, -101,
 -109, -110, -110, -22, 82,
 82, 82, -34, 82, 40, 20, -57, 84, 42, 21, 45, -111, 72, -110, -93, -94, -94,
 -50, 31, 63,
 126, -4, -115, 16, 11, 28, 60, 120, -80, 55, 35, 35, 99, -83, 90, -83, -26,
 110, -34, -68,
 -87, 53, 26, -115, 123, -118, -118, -118, -10, 127, -14, -55, 39, 61, 103,
 -50, -100, -87, -71, 113,
 -29, -122, 104, 98, 70, 80, -87, 84, -66, 105, -45, -90, -35, -65, 99, -57,
 -114, -90, -122, -122,
 -122, -67, 54, -101, 77, 13, 0, -111, -111, -111, 92, 90, 90, -38, 121, -32,
 86, 22, -29, 120,
 -90, 9, 0, 8, 8, -112, 17, -35, 91, -3, -68, -40, -25, -115, 57, 124, 16,
 -26, -115, 49,
 18, -18, -30, 49, 90, -72, -87, 6, 0, -122, -26, 16, 41, 54, 103, 68, 16, 95,
 124, -104,
 24, 120, -4, -12, -100, -124, 119, -117, 20, 10, 5, 82, 83, 83, -65, -24,
 -17, -17, 95, 123,
 -33, 125, -9, 77, 42, 44, 44, 92, 122, -37, -32, 0, -128, -27, -53, -105, 47,
 -119, -114, -114,
 30, -51, -71, -72, 77, -82, 86, 42, -107, -127, -30, -30, -30, 7, 90, 91, 91,
 49, 119, -18,
 -36, -22, -79, -11, 33, 49, 49, -79, -82, -93, -93, 3, -19, -19, -19, -72,
 118, -19, 26, -20,
 13, -91, 27, -72, 70, -107, 16, -12, -3, -63, -6, -20, 75, 55, 46, 126, 79,
 -19, 109, -52,
 -76, 8, -90, 111, -18, -113, 29, -36, -91, 72, -63, 85, 23, 35, -12, -99,
 -99, 117, -44, 90,
 -65, 34, -93, -88, 40, -4, -15, 80, -56, -90, -34, 98, -79, -52, -78, -37,
 -19, -32, 56, 46,
 108, -5, 12, -36, -22, -101, -78, -77, -77, 127, -80, 103, -49, -98, 35, 47,
 -66, -8, 98, 114,
 71, 71, -57, -85, 99, 107, 67, 84, 84, -44, -7, 96, -29, -59, 48, 12, 56,
 -88, 26, 2,
 -36, 55, -83, -124, -126, -18, -67, -105, 14, 116, 46, -13, -6, -8, 47, 111,
 -73, 119, 34, 73,
 64, 41, 113, 67, 35, -71, 92, 41, -10, -97, 106, 62, -4, 83, 98, -97, -75,
 -15, 123, 33,
 -103, 50, 68, 1, -83, 86, -5, 91, -87, 84, -54, -122, -97, -10, -42, -119,
 66, 78, 78, -50,
 -113, -113, 28, 57, -14, -53, -33, -4, -26, 55, 84, 75, 75, -53, -37, 86,
 -85, 117, -12, -52,
 71, 36, 18, 33, 58, 58, -6, 84, -16, -104, 49, 16, 8, -128, 37, 52, 109, -84,
 -96, 28,
 -99, -125, 34, 2, -112, -111, 87, 119, 14, 19, -39, 63, -66, -23, -98, -38,
 61, -52, 37, 93,
 -26, -123, -16, -121, -124, 52, 37, 64, 37, 27, -92, -44, -118, -81, 22, 48,
 98, 121, -88, -94,
 19, 111, 28, 57, 114, -28, 74, 74, 74, -54, -114, 112, -123, 69, 44, 22, 35,
 39, 39, -25,
 -105, -75, -75, -75, 47, -76, -76, -76, -64, 100, 50, 109, -19, -20, -20, 44,
 26, 27, 27, 17,
 17, 17, -120, -115, -115, 61, -53, -13, 60, 88, -106, -123, -53, -27, -126,
 -123, 91, 51, 20, -32,
 -103, 113, 93, -104, 92, -44, 47, -111, 17, -105, -73, -66, 112, 96, -26, 20,
 90, -103, -105, -59,
 -110, 9, 103, 4, 33, -4, 7, 35, -126, -108, 64, 44, -97, -70, 81, -109, -15,
 -77, -112, 23,
 27, 86, -19, -39, -77, 103, -65, -108, -112, -112, 112, 126, -20, 61, -111,
 72, -124, -36, -36, -36,
 -125, 37, 37, 37, 63, 0, -128, -67, 123, -9, -34, -37, -38, -38, -70, 109,
 -84, -21, 0, -128,
 92, 46, -65, -68, 125, -5, 118, 75, 100, 100, 36, -92, 82, 41, -82, 95, -65,
 14, -85, -43,
 10, -106, 87, -76, -115, 117, 23, 2, 2, -108, 116, 79, -7, -42, 21, -42, 13,
 -5, 62, -98,
 -26, 19, 36, 89, 75, 121, 42, -70, 23, 33, 68, 2, -30, 41, 111, 18, -55, -1,
 -13, -57,
 112, 88, -61, 42, -80, 107, -41, 46, 118, -26, -52, -103, 15, 78, -102, 52,
 -55, 26, 4, -97,
 -99, -99, 125, 100, -6, -12, -23, -85, 119, -20, -40, -63, 109, -39, -78, 69,
 -46, -42, -42, -74,
 -65, -81, -81, 79, 50, -15, 89, -75, 90, -35, 48, 50, 50, 2, -89, -45, 9,
 -89, -45, 9,
 -114, -29, 112, -18, -36, 57, -80, -68, -30, -62, -60, 55, -52, 80, 94, 68,
 -120, -70, 126, -74,
 104, 70, 115, -46, -66, -29, -71, -74, -127, -111, -92, 93, 1, -2, -106, -27,
 -67, 126, 6, 110,
 86, 15, 63, 57, -27, 12, -92, 57, 63, 8, -121, -13, -74, 10, 0, -64, -31,
 -61, -121, -51,
 121, 121, 121, -27, 49, 49, 49, -50, -52, -52, -52, -29, -71, -71, -71, -113,
 -67, -11, -42, 91,
 28, 0, 52, 54, 54, -2, 123, 71, 71, 71, -26, -60, 114, 79, -45, 52, 12, 6,
 -61, -103,
 -35, -69, 119, -93, -87, -87, 9, 39, 79, -98, -124, 66, -95, 64, 67, 67, 3,
 2, -124, -82,
 -51, -49, -123, -98, -62, 69, 50, 55, -108, 50, -66, -11, -99, -17, 20, 116,
 26, 56, -1, 64,
 1, 9, 30, -126, 0, 12, 7, 38, -97, 119, -110, -33, -98, -30, -32, -26, 44,
 34, 38, -17,
 14, 57, -109, 29, 93, -13, 118, 12, 0, -8, -32, -125, 15, 26, 86, -83, 90,
 117, 79, 68,
 68, -60, -48, -82, 93, -69, 124, 0, -80, 124, -7, 114, -29, -87, 83, -89,
 -98, 14, -9, -75,
 69, 46, -105, 35, 33, 33, -31, 84, 87, 87, 23, 102, -50, -100, 9, -106, 101,
 97, 48, 24,
 80, 82, 82, 2, -126, -23, -69, -32, 29, -111, 66, 34, 26, -17, -58, 20, -55,
 -63, -96, 104,
 -53, 103, 121, 75, 31, 35, 113, -126, 36, 5, 4, 120, 10, 28, -87, 61, 18,
 -101, -67, -85,
 -5, 78, -8, -18, -86, 0, 0, -20, -33, -65, 127, -76, -9, -34, -68, 121, -77,
 -14, -28, -55,
 -109, -1, 105, -79, 88, -62, -74, -114, 106, -75, -70, -97, 97, -104, -90,
 45, 91, -74, 96, 112,
 112, 16, 78, -89, 19, -79, -79, -79, -120, -119, -119, 65, 124, -50, -77, 22,
 -53, -87, 108, -101,
 0, -105, 97, 98, -88, -118, -88, 0, 68, -108, 29, 0, 32, 8, 4, -68, 92, -36,
 101, 66,
 60, -27, -51, -69, 97, -5, -117, 20, 24, 75, 3, 3, 3, 5, 102, -77, 57, -23,
 118, -11,
 65, -95, 80, -100, 91, -72, 112, 33, 58, 59, 59, -15, -52, 51, -49, -32, -58,
 -115, 27, 0,
 -128, 117, -21, -42, 33, 37, 37, 5, -124, -24, -27, -41, 56, -2, -38, -53,
 52, 121, -69, 44,
 77, 96, 4, 49, 109, -82, 64, -54, -46, -72, -36, 55, 61, -73, 17, 26, 71,
 127, 121, 19,
 14, -64, 100, 50, 93, 45, 46, 46, -82, 13, 4, 2, -23, 94, -81, 55, 110, -84,
 34, 52,
 77, 99, -38, -76, 105, -1, -67, 104, -47, -94, -38, -54, -54, 74, 12, 13, 13,
 65, 42, -107,
 34, 34, 34, 2, -59, -59, -59, -16, -7, 124, -120, -108, -104, -21, 124, 62,
 54, -121, -122, 43,
 -123, 36, 56, 16, -60, -83, -46, -51, -13, 36, 2, -126, -54, 71, -120, 19,
 119, 18, -118, 89,
 43, -94, -90, 31, -80, -34, 30, -59, 120, -6, -85, 44, 0, 0, 31, 127, -4,
 -15, -97, 1,
 -52, -98, 63, 127, -2, -110, -18, -18, -18, -17, -37, -19, -10, 121, 46,
 -105, 11, 50, -103, 12,
 49, 49, 49, -89, 74, 74, 74, -48, -39, -39, -119, 37, 75, -106, 96, -39, -78,
 101, -120, -118,
 -118, -62, -104, 79, 79, -20, -11, 75, -37, 42, 6, 88, -19, 18, 58, -48, 87,
 46, 34, -3,
 122, 1, -92, -45, -49, -85, 26, 57, 106, -46, -31, -104, -116, 3, 102, -32,
 -4, -19, 23, 15,
 67, 127, -9, 95, 13, 30, 123, -20, -79, -92, -42, -42, -42, 7, 40, -118,
 -102, 97, 52, 26,
 -41, -66, -12, -46, 75, -66, -106, -106, 22, -12, -11, -11, 65, 36, 18, 97,
 -2, -4, -7, 127,
 -17, 18, -1, -94, -1, -41, -12, -65, -117, 127, 58, -119, 114, -44, -38, -56,
 0, 0, 0, 0,
 73, 69, 78, 68, -82, 66, 96, -126
};
